(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    108343,       2465]
NotebookOptionsPosition[    103529,       2386]
NotebookOutlinePosition[    103963,       2403]
CellTagsIndexPosition[    103920,       2400]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Extract platelet thicknesses and radii from SAXS data", "Title",
 CellChangeTimes->{{3.854421073333592*^9, 3.854421085540827*^9}, {
  3.860138334587551*^9, 3.860138361009327*^9}, {3.889001234807024*^9, 
  3.889001235941153*^9}},ExpressionUUID->"9752d005-1219-465f-8e60-\
2082113917f8"],

Cell[TextData[{
 "This notebook contains the functions to calculate platelet thickness \
distributions from SAXS patterns.  Analysis of individual samples should be \
performed with the notebook ",
 StyleBox["Sample playground.nb",
  FontSlant->"Italic"],
 ".",
 "\nThe current notebook contains functions for the following steps:"
}], "Text",
 CellChangeTimes->{{3.854421073333592*^9, 3.854421085540827*^9}, {
  3.860138334587551*^9, 3.860138477031891*^9}, {3.8601400466828275`*^9, 
  3.8601400869865527`*^9}},ExpressionUUID->"49403409-d150-494f-b081-\
91ce56c28d83"],

Cell["\<\
Process (average, subtract background, merge), export and plot SAXS patterns\
\>", "Item",
 CellChangeTimes->{{3.854421073333592*^9, 3.854421085540827*^9}, {
  3.860138334587551*^9, 
  3.860138515531695*^9}},ExpressionUUID->"c5bb304f-f48f-4254-b437-\
103257a6e918"],

Cell["\<\
Data fitting (calculate (polydisperse) form factor, fit slopes (note that \
intensity fit has been remove for the full form factor incl platelet radius))\
\
\>", "Item",
 CellChangeTimes->{{3.854421073333592*^9, 3.854421085540827*^9}, {
  3.860138334587551*^9, 3.860138516926824*^9}, {3.8601386478729086`*^9, 
  3.860138664129044*^9}, {3.889498683509451*^9, 
  3.8894987072659907`*^9}},ExpressionUUID->"ae041ac8-eae0-47a3-9bd9-\
39e8721130f8"],

Cell[CellGroupData[{

Cell["Import data & setup functions", "Subsubsection",
 CellChangeTimes->{{3.854421073333592*^9, 
  3.854421085540827*^9}},ExpressionUUID->"e214e2f0-1723-47e3-b5e6-\
cc97977345b1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"SetDirectory", "[", 
    RowBox[{"NotebookDirectory", "[", "]"}], "]"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}], ";"}], 
   "*)"}]}]], "Input",
 CellChangeTimes->{3.891917782999442*^9, 3.9052283361177278`*^9},
 CellLabel->"In[1]:=",ExpressionUUID->"6a1e2f36-ed4d-4204-a5ee-f5fb0ba7e773"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"dataPath", "=", 
    RowBox[{"FileNameJoin", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"NotebookDirectory", "[", "]"}], ",", 
       "\"\<2022-08_new_data/Graphene_data_capillaries_ave\>\""}], "}"}], 
     "]"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"dataPath", "=", 
    RowBox[{"FileNameJoin", "[", 
     RowBox[{"{", 
      RowBox[{
      "\"\<C:/Users/s168562/OneDrive - TU \
Eindhoven/PhD/4_Colloidal_interactions/ESRF/Analysis\>\"", ",", 
       "\"\<2023-07_new_data/Laura-E-series\>\""}], "}"}], "]"}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"dataPath", "=", 
    RowBox[{"FileNameJoin", "[", 
     RowBox[{"{", 
      RowBox[{
      "\"\<C:/Users/s168562/OneDrive - TU \
Eindhoven/PhD/4_Colloidal_interactions/ESRF/Analysis\>\"", ",", 
       "\"\<2023-07_new_data/Lisette\>\""}], "}"}], "]"}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "dataPath", "=", 
    "\"\<C:\\\\Users\\\\s168562\\\\OneDrive-TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\ESRF\\\\Analysis\\\\2022-08_\
new_data\\\\Graphene_data_capillaries_ave\>\""}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"dataPath", "=", 
    RowBox[{"FileNameJoin", "[", 
     RowBox[{"{", 
      RowBox[{
      "\"\<C:/Users/s168562/OneDrive - TU \
Eindhoven/PhD/4_Colloidal_interactions/ESRF/Analysis\>\"", ",", 
       "\"\<2022-08_new_data/Graphene_data_capillaries_ave\>\""}], "}"}], 
     "]"}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetDirectory", "[", "dataPath", "]"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"fileNames", "=", 
     RowBox[{"FileNames", "[", 
      RowBox[{
      "RegularExpression", "[", "\"\<\\\\w+eiger2_\\\\d+_ave.h5\>\"", "]"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"Length", "[", "fileNames", "]"}]}]}]], "Input",
 CellChangeTimes->{{3.843291109702825*^9, 3.843291129724827*^9}, {
   3.843291167128108*^9, 3.843291185479764*^9}, {3.843291219598308*^9, 
   3.843291222024798*^9}, {3.843291264579451*^9, 3.8432912853783493`*^9}, 
   3.843291319173628*^9, {3.8432913509667788`*^9, 3.843291375972494*^9}, {
   3.843291451400524*^9, 3.843291477387067*^9}, {3.8432915074978447`*^9, 
   3.843291534313446*^9}, {3.843292849473691*^9, 3.843292942812584*^9}, {
   3.8432931554440536`*^9, 3.843293227171956*^9}, {3.843293396905971*^9, 
   3.8432934076677513`*^9}, {3.843293598815793*^9, 3.8432936066087017`*^9}, {
   3.84329364169765*^9, 3.843293676946286*^9}, {3.8432937236680613`*^9, 
   3.843293772333598*^9}, {3.843294707626026*^9, 3.843294724210083*^9}, 
   3.843294770372671*^9, {3.8432948815026712`*^9, 3.8432948844789762`*^9}, {
   3.843295139951911*^9, 3.843295151390843*^9}, {3.843296147653944*^9, 
   3.843296185726388*^9}, {3.843296554609067*^9, 3.843296592633421*^9}, {
   3.843296636066904*^9, 3.843296639883025*^9}, {3.8432966844608583`*^9, 
   3.843296707229643*^9}, {3.843296858083069*^9, 3.843296863457725*^9}, {
   3.843297628887661*^9, 3.8432976613287487`*^9}, {3.8432987537158613`*^9, 
   3.843298773059194*^9}, {3.843298823885009*^9, 3.843298834244919*^9}, {
   3.843299789697318*^9, 3.843299804010457*^9}, {3.852781031022092*^9, 
   3.8527810772744493`*^9}, {3.852781158568071*^9, 3.852781201094832*^9}, {
   3.8527812588052597`*^9, 3.852781283480824*^9}, {3.852781419697466*^9, 
   3.852781430649639*^9}, {3.852781469335927*^9, 3.852781497438036*^9}, {
   3.852781543616589*^9, 3.852781633868348*^9}, {3.8527816651702337`*^9, 
   3.852781748919075*^9}, {3.852781791308778*^9, 3.852781813234481*^9}, {
   3.8527818729040623`*^9, 3.852781874767733*^9}, {3.852782031664762*^9, 
   3.852782067804142*^9}, {3.852782890656323*^9, 3.852782892951396*^9}, 
   3.852784938827908*^9, 3.852785110185223*^9, 3.852785990266891*^9, {
   3.8527861525799932`*^9, 3.852786159462245*^9}, {3.8527862029249353`*^9, 
   3.852786226420244*^9}, {3.853381378758465*^9, 3.853381378945614*^9}, 
   3.853496150649447*^9, {3.8538177863332767`*^9, 3.8538177873549957`*^9}, 
   3.853818176511339*^9, {3.853833034447925*^9, 3.853833034613881*^9}, {
   3.854098398903439*^9, 3.8540983999200363`*^9}, {3.860137189571525*^9, 
   3.860137217401352*^9}, {3.885971180865988*^9, 3.885971188443076*^9}, {
   3.888309497309559*^9, 3.888309616445239*^9}, {3.8894988210904903`*^9, 
   3.889498848750657*^9}, {3.8895036360318656`*^9, 3.889503646388072*^9}, {
   3.8895036902148943`*^9, 3.8895037221118603`*^9}, {3.889503752320318*^9, 
   3.889503789653923*^9}, {3.8895039643492126`*^9, 3.889504039947297*^9}, {
   3.891917778214884*^9, 3.8919177861047926`*^9}, 3.9041237661720533`*^9, {
   3.9052284695314145`*^9, 3.9052284741268473`*^9}, {3.9156928328838043`*^9, 
   3.9156928402085423`*^9}, {3.917414892789137*^9, 3.917414901310392*^9}},
 CellLabel->"In[2]:=",ExpressionUUID->"bb5b9391-51b5-4754-9301-f8ac33c801e3"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\ESRF\\\\Analysis\\\\2022-08_\
new_data\\\\Graphene_data_capillaries_ave\"\>"], "Output",
 CellChangeTimes->{
  3.8895036121748714`*^9, 3.889503647604984*^9, 3.8895037225313816`*^9, 
   3.889503796811266*^9, 3.8895038798579345`*^9, {3.889504042983837*^9, 
   3.8895040528657637`*^9}, 3.889668463822626*^9, 3.890202604224517*^9, 
   3.890976837791486*^9, 3.8914129610421104`*^9, 3.891490100998623*^9, {
   3.8919177898508825`*^9, 3.891917801264139*^9}, 3.8919181780843434`*^9, 
   3.892609275047814*^9, 3.9023134693075624`*^9, 3.904123771407646*^9, 
   3.906015705863716*^9, 3.9137856144863844`*^9, 3.915692606134824*^9, 
   3.9156927264171033`*^9, 3.915692787112469*^9, 3.9170003951910515`*^9, 
   3.9174149091218376`*^9, 3.917416246712593*^9, 3.9174217918251686`*^9, 
   3.917423428895361*^9},
 CellLabel->"Out[2]=",ExpressionUUID->"233d6aa5-d457-412b-8648-9fb24a1d7329"],

Cell[BoxData["2655"], "Output",
 CellChangeTimes->{
  3.8895036121748714`*^9, 3.889503647604984*^9, 3.8895037225313816`*^9, 
   3.889503796811266*^9, 3.8895038798579345`*^9, {3.889504042983837*^9, 
   3.8895040528657637`*^9}, 3.889668463822626*^9, 3.890202604224517*^9, 
   3.890976837791486*^9, 3.8914129610421104`*^9, 3.891490100998623*^9, {
   3.8919177898508825`*^9, 3.891917801264139*^9}, 3.8919181780843434`*^9, 
   3.892609275047814*^9, 3.9023134693075624`*^9, 3.904123771407646*^9, 
   3.906015705863716*^9, 3.9137856144863844`*^9, 3.915692606134824*^9, 
   3.9156927264171033`*^9, 3.915692787112469*^9, 3.9170003951910515`*^9, 
   3.9174149091218376`*^9, 3.917416246712593*^9, 3.9174217918251686`*^9, 
   3.917423429135147*^9},
 CellLabel->"Out[5]=",ExpressionUUID->"cfdb79b9-eb3d-432a-8f19-2b7a9b73b56f"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Extract", " ", "all", " ", "file", " ", "names"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"SetSharedVariable", "[", "j", "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"j", "=", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Monitor", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"titles", "=", 
       RowBox[{"ParallelTable", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"j", "++"}], ";", "\[IndentingNewLine]", 
          RowBox[{"title", "=", 
           RowBox[{"StringRiffle", "[", 
            RowBox[{
             RowBox[{"Import", "[", 
              RowBox[{
               RowBox[{"FileNameJoin", "[", 
                RowBox[{"{", 
                 RowBox[{"dataPath", ",", 
                  RowBox[{"fileNames", "[", 
                   RowBox[{"[", "i", "]"}], "]"}]}], "}"}], "]"}], ",", 
               RowBox[{"{", 
                RowBox[{"{", 
                 RowBox[{
                 "\"\</entry_0000/PyFAI/id02-eiger2-saxs/header/Title\>\"", 
                  ",", "\"\</entry_0000/PyFAI/id02-eiger2-saxs/header/\
SampleDistance\>\""}], "}"}], "}"}]}], "]"}], ",", "\"\<_\>\""}], "]"}]}], 
          ";", "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{"title", ",", 
            RowBox[{"fileNames", "[", 
             RowBox[{"[", "i", "]"}], "]"}]}], "}"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"i", ",", 
           RowBox[{"Length", "[", "fileNames", "]"}]}], "}"}]}], 
        "\[IndentingNewLine]", "]"}]}], ",", "\[IndentingNewLine]", "j"}], 
     "\[IndentingNewLine]", "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{
  3.852786431189885*^9, {3.852787104362198*^9, 3.852787107216403*^9}, {
   3.8534692703745604`*^9, 3.853469276630739*^9}, {3.853489232693318*^9, 
   3.853489233219405*^9}, {3.853499517183794*^9, 3.853499520757019*^9}, {
   3.8534995809431887`*^9, 3.853499582335005*^9}, {3.860137268641552*^9, 
   3.860137282028754*^9}, 3.906015964578121*^9},
 CellLabel->"In[6]:=",ExpressionUUID->"fc5fd8e9-fab4-4b5c-b2af-d0e7dff8366f"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"sampleFiles", "=", 
    RowBox[{"GroupBy", "[", 
     RowBox[{"titles", ",", 
      RowBox[{"First", "\[Rule]", "Last"}]}], "]"}]}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Group", " ", "files", " ", "by", " ", "their", " ", "sample", " ", 
    "name"}], "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Function", " ", "to", " ", "import", " ", "q", " ", "data", " ", "for", 
    " ", "a", " ", "certain", " ", "filename"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"scatteringDataFile", "[", "filename_", "]"}], ":=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Import", "[", 
       RowBox[{"filename", ",", "\"\</entry_0000/PyFAI/result_ave/q\>\""}], 
       "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Import", "[", 
        RowBox[{
        "filename", ",", "\"\</entry_0000/PyFAI/result_ave/data\>\""}], "]"}],
        "[", 
       RowBox[{"[", "1", "]"}], "]"}]}], "}"}], "\[Transpose]"}]}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Function", " ", "to", " ", "import", " ", "all", " ", "q", " ", "data", 
    " ", "files", " ", "for", " ", "one", " ", "sample"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"scatteringDataSample", "[", "samplename_", "]"}], ":=", 
    RowBox[{"scatteringDataFile", "/@", 
     RowBox[{"sampleFiles", "[", "samplename", "]"}]}]}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"scatteringDataSampleAveraged", "[", "samplename_", "]"}], ":=", 
     
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"#", "[", 
           RowBox[{"[", 
            RowBox[{";;", ",", "1", ",", "1"}], "]"}], "]"}], ",", 
          RowBox[{"MeanAround", "/@", 
           RowBox[{"#", "[", 
            RowBox[{"[", 
             RowBox[{";;", ",", ";;", ",", "2"}], "]"}], "]"}]}]}], "}"}], 
        "\[Transpose]"}], "&"}], "@", 
      RowBox[{"GatherBy", "[", 
       RowBox[{
        RowBox[{"Flatten", "[", 
         RowBox[{
          RowBox[{"scatteringDataSample", "[", "samplename", "]"}], ",", 
          "1"}], "]"}], ",", "First"}], "]"}]}]}], ";"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"scatteringDataSampleAveragedErrors", "[", "samplename_", "]"}], 
     ":=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"#", "[", 
           RowBox[{"[", 
            RowBox[{";;", ",", "1", ",", "1"}], "]"}], "]"}], ",", 
          RowBox[{"MeanAround", "/@", 
           RowBox[{"#", "[", 
            RowBox[{"[", 
             RowBox[{";;", ",", ";;", ",", "2"}], "]"}], "]"}]}]}], "}"}], 
        "\[Transpose]"}], "&"}], "@", 
      RowBox[{"GatherBy", "[", 
       RowBox[{
        RowBox[{"Flatten", "[", 
         RowBox[{
          RowBox[{"scatteringDataSample", "[", "samplename", "]"}], ",", 
          "1"}], "]"}], ",", "First"}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"scatteringDataSampleAveraged", "[", "samplename_", "]"}], ":=", 
    RowBox[{"Mean", "[", 
     RowBox[{
      RowBox[{"GatherBy", "[", 
       RowBox[{
        RowBox[{"Flatten", "[", 
         RowBox[{
          RowBox[{"scatteringDataSample", "[", "samplename", "]"}], ",", 
          "1"}], "]"}], ",", "First"}], "]"}], "\[Transpose]"}], "]"}]}], 
   ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"Average", " ", "all", " ", "measurements"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"scatteringDataSampleStdev", "[", "samplename_", "]"}], ":=", 
    RowBox[{"StandardDeviation", "[", 
     RowBox[{
      RowBox[{"GatherBy", "[", 
       RowBox[{
        RowBox[{"Flatten", "[", 
         RowBox[{
          RowBox[{"scatteringDataSample", "[", "samplename", "]"}], ",", 
          "1"}], "]"}], ",", "First"}], "]"}], "\[Transpose]"}], "]"}]}], 
   ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"Calculate", " ", "standard", " ", "deviation"}], "*)"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"scatteringDataSampleAveragedErrors", "[", "samplename_", "]"}], ":=", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"scatteringDataSampleAveraged", "[", "samplename", "]"}], 
       "\[Transpose]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
     RowBox[{"(*", " ", 
      RowBox[{
      "Calculate", " ", "average", " ", "and", " ", "stdev", " ", "in", " ", 
       "one", " ", "go"}], "*)"}], "\[IndentingNewLine]", 
     RowBox[{"Around", "@@@", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"scatteringDataSampleAveraged", "[", "samplename", "]"}], 
            "\[Transpose]"}], "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"scatteringDataSampleStdev", "[", "samplename", "]"}], 
            "\[Transpose]"}], "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], "}"}], "\[Transpose]"}], 
       ")"}]}]}], "\[IndentingNewLine]", "}"}], "\[Transpose]"}]}]}], "Input",\

 CellChangeTimes->{{3.852781860752527*^9, 3.852781861400449*^9}, {
   3.852782427495048*^9, 3.852782432845196*^9}, {3.852782490522458*^9, 
   3.8527825233607388`*^9}, 3.852782757511119*^9, {3.8527828983994617`*^9, 
   3.852782923717813*^9}, {3.852783954273013*^9, 3.852783958577043*^9}, {
   3.852784217988599*^9, 3.852784232189209*^9}, {3.852784588124271*^9, 
   3.852784630667053*^9}, 3.8527849493876867`*^9, 3.852786296410307*^9, {
   3.852786445171461*^9, 3.8527864639719877`*^9}, 3.852786739567677*^9, {
   3.852787449131702*^9, 3.852787450514557*^9}, {3.853381975213027*^9, 
   3.853381976205628*^9}, {3.853382404274076*^9, 3.85338240456852*^9}, {
   3.85340333020494*^9, 3.853403408623046*^9}, {3.85340345847932*^9, 
   3.853403507151403*^9}, {3.853409529667601*^9, 3.8534095895008907`*^9}, {
   3.853409682647615*^9, 3.853409684334144*^9}, {3.853410131707053*^9, 
   3.85341017818784*^9}, {3.8538181053955297`*^9, 3.853818151693227*^9}, {
   3.8538238300771923`*^9, 3.853823831444284*^9}, {3.8544235682712183`*^9, 
   3.854423596844871*^9}, {3.8601372879871793`*^9, 3.860137300912186*^9}, {
   3.8601373341336937`*^9, 3.860137513416378*^9}, {3.8601377878238845`*^9, 
   3.860137825471859*^9}, 3.8601381170176554`*^9, 3.8601381527942257`*^9},
 CellLabel->"In[9]:=",ExpressionUUID->"963c927a-6081-41b1-bcc3-11370c5e23da"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Data processing functions", "Subsection"]], \
"Subsubsection",
 CellChangeTimes->{{3.8601381777337103`*^9, 3.8601382230184765`*^9}, {
  3.8601382660907316`*^9, 
  3.8601382667694025`*^9}},ExpressionUUID->"bb1efd3e-4cfd-424b-89f2-\
969547bc7a05"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Function", " ", "to", " ", "subtract", " ", "background"}], 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"scatteringDataSampleAveragedSubtracted", "[", 
     RowBox[{"samplename_", ",", "backgroundname_", ",", "c_"}], "]"}], ":=", 
    
    RowBox[{"Module", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"scatdata", ",", "backdata"}], "}"}], ",", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"scatdata", "=", 
        RowBox[{
         RowBox[{"scatteringDataSampleAveraged", "[", "samplename", "]"}], 
         "\[Transpose]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"backdata", "=", 
        RowBox[{
         RowBox[{"scatteringDataSampleAveraged", "[", "backgroundname", "]"}],
          "\[Transpose]"}]}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"scatdata", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "==", 
          RowBox[{"backdata", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{"Select", "[", 
          RowBox[{"(*", 
           RowBox[{
            RowBox[{
            "selecting", " ", "only", " ", "positive", " ", "intensities"}], 
            ";", " ", 
            RowBox[{"change", " ", "if", " ", "desired"}]}], "*)"}], 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"scatdata", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", 
              RowBox[{
               RowBox[{"scatdata", "[", 
                RowBox[{"[", "2", "]"}], "]"}], "-", 
               RowBox[{"c", " ", 
                RowBox[{"backdata", "[", 
                 RowBox[{"[", "2", "]"}], "]"}]}]}]}], "}"}], 
            "\[Transpose]"}], ",", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"Positive", "[", 
             RowBox[{"#", "[", 
              RowBox[{"[", "2", "]"}], "]"}], "]"}], "&"}]}], "]"}], ",", 
         "\[IndentingNewLine]", "Null"}], "\[IndentingNewLine]", "]"}]}]}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Function", " ", "to", " ", "bin", " ", "the", " ", 
     RowBox[{"(", 
      RowBox[{"already", " ", 
       RowBox[{"averaged", "/", "background"}], " ", "subtracted", " ", "if", 
       " ", "desired"}], ")"}], " ", "data"}], "*)"}], "\[IndentingNewLine]", 
   
   RowBox[{
    RowBox[{
     RowBox[{"binData", "[", 
      RowBox[{"list_", ",", "binning_"}], "]"}], ":=", 
     RowBox[{"Block", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"logData", "=", 
          RowBox[{"Log", "[", "list", "]"}]}], ",", "\[IndentingNewLine]", 
         "binnedRawLogData", ",", "\[IndentingNewLine]", "binnedLogData"}], 
        "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"NumberQ", "[", "binning", "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"binnedRawLogData", "=", 
           RowBox[{"BinListsBy", "[", 
            RowBox[{"logData", ",", 
             RowBox[{"{", 
              RowBox[{"First", ",", 
               RowBox[{"Min", "[", 
                RowBox[{"logData", "[", 
                 RowBox[{"[", 
                  RowBox[{";;", ",", "1"}], "]"}], "]"}], "]"}], ",", 
               RowBox[{"Max", "[", 
                RowBox[{"logData", "[", 
                 RowBox[{"[", 
                  RowBox[{";;", ",", "1"}], "]"}], "]"}], "]"}], ",", 
               "binning"}], "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"binnedLogData", "=", 
           RowBox[{
            RowBox[{"{", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"Mean", "/@", 
               RowBox[{"binnedRawLogData", "[", 
                RowBox[{"[", 
                 RowBox[{";;", ",", ";;", ",", "1"}], "]"}], "]"}]}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"MeanAround", "/@", 
               RowBox[{"binnedRawLogData", "[", 
                RowBox[{"[", 
                 RowBox[{";;", ",", ";;", ",", "2"}], "]"}], "]"}]}]}], 
             "\[IndentingNewLine]", "}"}], "\[Transpose]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"Return", "[", 
           RowBox[{"Exp", "[", "binnedLogData", "]"}], "]"}], ";"}]}], 
        "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", "]"}]}], ";"}],
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "Function", " ", "to", " ", "export", " ", "a", " ", "dataset", " ", 
      "containing", " ", "three", " ", 
      RowBox[{"columns", ":", " ", "q"}]}], ",", " ", 
     RowBox[{"Mean", 
      RowBox[{"(", "I", ")"}], " ", "and", " ", "std", 
      RowBox[{"(", "I", ")"}]}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"exportData", "[", "list_", "]"}], " ", ":=", " ", 
     RowBox[{"Block", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"exportlist", " ", "=", " ", 
          RowBox[{"{", "}"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{"datamergedbinned", " ", "=", " ", "list"}]}], 
        "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Do", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"If", "[", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"TrueQ", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"Head", "[", 
                RowBox[{"datamergedbinned", "[", 
                 RowBox[{"[", 
                  RowBox[{"i", ",", "2"}], "]"}], "]"}], "]"}], "\[Equal]", 
               "Around"}], "||", 
              RowBox[{
               RowBox[{"Head", "[", 
                RowBox[{"datamergedbinned", "[", 
                 RowBox[{"[", 
                  RowBox[{"i", ",", "2"}], "]"}], "]"}], "]"}], "\[Equal]", 
               "Real"}]}], "]"}], ",", "\[IndentingNewLine]", 
            RowBox[{"AppendTo", "[", 
             RowBox[{
             "exportlist", ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
              
              RowBox[{"{", "\[IndentingNewLine]", 
               RowBox[{
                RowBox[{"datamergedbinned", "[", 
                 RowBox[{"[", 
                  RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", 
                "\[IndentingNewLine]", "\[IndentingNewLine]", 
                RowBox[{"Which", "[", "\[IndentingNewLine]", 
                 RowBox[{
                  RowBox[{"TrueQ", "[", 
                   RowBox[{
                    RowBox[{"Head", "[", 
                    RowBox[{"datamergedbinned", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "2"}], "]"}], "]"}], "]"}], "\[Equal]", 
                    "Around"}], "]"}], ",", "\[IndentingNewLine]", 
                  RowBox[{
                   RowBox[{"datamergedbinned", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "2"}], "]"}], "]"}], "[", 
                   "\"\<Value\>\"", "]"}], ",", "\[IndentingNewLine]", 
                  RowBox[{"TrueQ", "[", 
                   RowBox[{
                    RowBox[{"Head", "[", 
                    RowBox[{"datamergedbinned", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "2"}], "]"}], "]"}], "]"}], "\[Equal]", 
                    "Real"}], "]"}], ",", "\[IndentingNewLine]", 
                  RowBox[{"datamergedbinned", "[", 
                   RowBox[{"[", 
                    RowBox[{"i", ",", "2"}], "]"}], "]"}], ",", 
                  "\[IndentingNewLine]", "True", ",", "\[IndentingNewLine]", 
                  "Null"}], "\[IndentingNewLine]", "]"}], ",", 
                "\[IndentingNewLine]", "\[IndentingNewLine]", 
                RowBox[{"If", "[", "\[IndentingNewLine]", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"Head", "[", "\[IndentingNewLine]", 
                    RowBox[{"datamergedbinned", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "2"}], "]"}], "]"}], 
                    "\[IndentingNewLine]", "]"}], "\[Equal]", "Around"}], ",",
                   "\[IndentingNewLine]", 
                  RowBox[{
                   RowBox[{"datamergedbinned", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "2"}], "]"}], "]"}], "[", 
                   "\"\<Uncertainty\>\"", "]"}], ",", "\[IndentingNewLine]", 
                  "0", ",", "\[IndentingNewLine]", "0"}], 
                 "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
               "}"}]}], "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]",
            "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{"i", ",", 
            RowBox[{"Length", "[", "datamergedbinned", "]"}]}], "}"}]}], 
         "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"Return", "[", "exportlist", "]"}], ";"}]}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Function", " ", "to", " ", "extract", " ", "the", " ", "slopes", " ", 
     "from", " ", "the", " ", "pattern"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"slope", "[", 
      RowBox[{
       RowBox[{"list_", "?", "ListQ"}], ",", 
       RowBox[{"binning_", ":", "False"}]}], "]"}], ":=", 
     RowBox[{"Block", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"logData", "=", 
          RowBox[{"Log", "[", "list", "]"}]}], ",", "\[IndentingNewLine]", 
         "binnedRawLogData", ",", "\[IndentingNewLine]", "binnedLogData", ",",
          "\[IndentingNewLine]", "slopesBinned", ",", "\[IndentingNewLine]", 
         "slopes"}], "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"NumberQ", "[", "binning", "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"binnedRawLogData", "=", 
           RowBox[{"BinListsBy", "[", 
            RowBox[{"logData", ",", 
             RowBox[{"{", 
              RowBox[{"First", ",", 
               RowBox[{"Min", "[", 
                RowBox[{"logData", "[", 
                 RowBox[{"[", 
                  RowBox[{";;", ",", "1"}], "]"}], "]"}], "]"}], ",", 
               RowBox[{"Max", "[", 
                RowBox[{"logData", "[", 
                 RowBox[{"[", 
                  RowBox[{";;", ",", "1"}], "]"}], "]"}], "]"}], ",", 
               "binning"}], "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"binnedLogData", "=", 
           RowBox[{
            RowBox[{"{", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"Mean", "/@", 
               RowBox[{"binnedRawLogData", "[", 
                RowBox[{"[", 
                 RowBox[{";;", ",", ";;", ",", "1"}], "]"}], "]"}]}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"MeanAround", "/@", 
               RowBox[{"binnedRawLogData", "[", 
                RowBox[{"[", 
                 RowBox[{";;", ",", ";;", ",", "2"}], "]"}], "]"}]}]}], 
             "\[IndentingNewLine]", "}"}], "\[Transpose]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"slopesBinned", "=", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Exp", "[", 
               RowBox[{"MovingAverage", "[", 
                RowBox[{
                 RowBox[{"binnedLogData", "[", 
                  RowBox[{"[", 
                   RowBox[{";;", ",", "1"}], "]"}], "]"}], ",", "2"}], "]"}], 
               "]"}], ",", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"#", "[", 
                  RowBox[{"[", "2", "]"}], "]"}], "/", 
                 RowBox[{"#", "[", 
                  RowBox[{"[", "1", "]"}], "]"}]}], "&"}], "/@", 
               RowBox[{"Differences", "[", "binnedLogData", "]"}]}]}], "}"}], 
            "\[Transpose]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"Return", "[", "slopesBinned", "]"}], ";"}], ",", 
         "\[IndentingNewLine]", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"slopes", "=", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Exp", "[", 
               RowBox[{"MovingAverage", "[", 
                RowBox[{
                 RowBox[{"logData", "[", 
                  RowBox[{"[", 
                   RowBox[{";;", ",", "1"}], "]"}], "]"}], ",", "2"}], "]"}], 
               "]"}], ",", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"#", "[", 
                  RowBox[{"[", "2", "]"}], "]"}], "/", 
                 RowBox[{"#", "[", 
                  RowBox[{"[", "1", "]"}], "]"}]}], "&"}], "/@", 
               RowBox[{"Differences", "[", "logData", "]"}]}]}], "}"}], 
            "\[Transpose]"}]}], ";", " ", 
          RowBox[{"(*", " ", 
           RowBox[{
            RowBox[{
             RowBox[{
             "Return", " ", "in", " ", "the", " ", "first", " ", "column", 
              " ", "the", " ", "q"}], "-", 
             RowBox[{"value", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{
                 "actually", " ", "the", " ", "exponent", " ", "of", " ", 
                  "the", " ", "natural", " ", "log", " ", "of", " ", "the", 
                  " ", "q"}], "-", "value"}], ",", " ", 
                RowBox[{
                 RowBox[{"hence", " ", "the", " ", "q"}], "-", 
                 RowBox[{"value", " ", "itself"}]}]}], ")"}]}]}], ",", " ", 
            RowBox[{"in", " ", "the", " ", "second", " ", 
             RowBox[{
              RowBox[{"column", " ", "[", 
               RowBox[{
                RowBox[{"ln", 
                 RowBox[{"(", 
                  RowBox[{"I", 
                   RowBox[{"(", 
                    RowBox[{"q", "+", "1"}], ")"}]}], ")"}]}], "-", 
                RowBox[{"ln", 
                 RowBox[{"(", 
                  RowBox[{"I", 
                   RowBox[{"(", "q", ")"}]}], ")"}]}]}], "]"}], "/", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"ln", 
                 RowBox[{"(", 
                  RowBox[{"q", "+", "1"}], ")"}]}], "-", 
                RowBox[{"ln", 
                 RowBox[{"(", "q", ")"}]}]}], "]"}]}], " ", 
             RowBox[{"(", 
              RowBox[{
              "effectively", " ", "the", " ", "slope", " ", "in", " ", "each",
                " ", "point"}], ")"}]}]}], "*)"}], "\[IndentingNewLine]", 
          RowBox[{"Return", "[", "slopes", "]"}], ";"}]}], 
        "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", "]"}]}], ";"}],
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"BinListsBy", "[", 
     RowBox[{"data_List", ",", " ", "binspecs__List"}], "]"}], " ", ":=", " ", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "fs", ",", " ", "idata", ",", " ", "len", ",", " ", "out", ",", " ", 
        "dims"}], "}"}], ",", " ", 
      RowBox[{
       RowBox[{"len", " ", "=", " ", 
        RowBox[{"Length", "[", "data", "]"}]}], ";", " ", 
       RowBox[{"fs", " ", "=", " ", 
        RowBox[{"{", "binspecs", "}"}]}], ";", " ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"AllTrue", "[", 
          RowBox[{"fs", ",", " ", 
           RowBox[{
            RowBox[{"MatchQ", "[", 
             RowBox[{"#1", ",", " ", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"_", ",", " ", 
                 RowBox[{"_", "?", "NumericQ"}], ",", " ", 
                 RowBox[{"_", "?", "NumericQ"}]}], "}"}], " ", "|", " ", 
               RowBox[{"{", 
                RowBox[{"_", ",", " ", 
                 RowBox[{"_", "?", "NumericQ"}], ",", " ", 
                 RowBox[{"_", "?", "NumericQ"}], ",", " ", 
                 RowBox[{"_", "?", "NumericQ"}]}], "}"}]}]}], "]"}], " ", 
            "&"}]}], " ", "]"}], ",", " ", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"len", " ", ">", " ", "0"}], ",", " ", 
           RowBox[{
            RowBox[{"idata", " ", "=", " ", 
             RowBox[{"Table", "[", 
              RowBox[{
               RowBox[{"f", " ", "/@", " ", "data"}], ",", " ", 
               RowBox[{"{", 
                RowBox[{"f", ",", " ", 
                 RowBox[{"fs", "[", 
                  RowBox[{"[", 
                   RowBox[{"All", ",", "1"}], "]"}], "]"}]}], "}"}]}], 
              "]"}]}], ";", " ", 
            RowBox[{"AppendTo", "[", 
             RowBox[{"idata", ",", " ", 
              RowBox[{"Range", "[", "len", "]"}]}], "]"}], ";", " ", 
            RowBox[{"out", " ", "=", " ", 
             RowBox[{"BinLists", "[", 
              RowBox[{
               RowBox[{"Transpose", "[", "idata", "]"}], ",", " ", 
               RowBox[{"Sequence", " ", "@@", " ", 
                RowBox[{"Rest", " ", "/@", " ", "fs"}]}], ",", " ", 
               RowBox[{"{", 
                RowBox[{"0", ",", " ", 
                 RowBox[{"len", " ", "+", " ", "1"}], ",", " ", 
                 RowBox[{"len", " ", "+", " ", "1"}]}], "}"}]}], "]"}]}], ";",
             " ", 
            RowBox[{"out", " ", "=", " ", 
             RowBox[{"out", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"Sequence", " ", "@@", " ", 
                 RowBox[{"ConstantArray", "[", 
                  RowBox[{"All", ",", " ", 
                   RowBox[{"Length", "[", "fs", "]"}]}], "]"}]}], ",", "1", 
                ",", "All", ",", 
                RowBox[{"-", "1"}]}], "]"}], "]"}]}], ";", " ", 
            RowBox[{"Map", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"data", "[", 
                RowBox[{"[", "#1", "]"}], "]"}], " ", "&"}], " ", ",", " ", 
              "out", ",", " ", 
              RowBox[{"{", 
               RowBox[{"Length", "[", "fs", "]"}], "}"}]}], "]"}]}], ",", " ", 
           RowBox[{
            RowBox[{"dims", " ", "=", " ", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"Length", "[", 
                  RowBox[{"Range", " ", "@@", " ", "#1"}], "]"}], " ", "-", 
                 " ", "1"}], " ", "&"}], " ", ")"}], " ", "/@", " ", 
              RowBox[{"Rest", " ", "/@", " ", "fs"}]}]}], ";", " ", 
            RowBox[{"ConstantArray", "[", 
             RowBox[{
              RowBox[{"{", "}"}], ",", " ", "dims"}], "]"}]}]}], "]"}], ",", 
         " ", 
         RowBox[{"Message", "[", 
          RowBox[{
           RowBox[{"BinListsBy", "::", "invalidspec"}], ",", " ", "fs"}], 
          "]"}]}], "]"}]}]}], "]"}]}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"BinListsBy", "::", "invalidspec"}], " ", "=", " ", 
     "\"\<One or more of your binning specifications `1` is incorrect\
\[Ellipsis]\>\""}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"Sort", "[", 
    RowBox[{"Keys", "[", "sampleFiles", "]"}], "]"}], "\n", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Merging", " ", "data", " ", "sets"}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mergeData", "[", 
     RowBox[{
      RowBox[{"dataset1_", "?", "ListQ"}], ",", 
      RowBox[{"dataset2_", "?", "ListQ"}]}], "]"}], ":=", 
    RowBox[{"Block", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"data1", "=", 
         RowBox[{"Log", "[", "dataset1", "]"}]}], ",", "\[IndentingNewLine]", 
        
        RowBox[{"data2", "=", 
         RowBox[{"Log", "[", "dataset2", "]"}]}], ",", "\[IndentingNewLine]", 
        "overlapRange", ",", "\[IndentingNewLine]", "overlap1", ",", 
        "\[IndentingNewLine]", "overlap2", ",", "\[IndentingNewLine]", 
        "overlappos", ",", "\[IndentingNewLine]", "scale", ",", 
        "\[IndentingNewLine]", "cutoff", ",", "\[IndentingNewLine]", 
        "cutoffno", ",", "\[IndentingNewLine]", "movingstdev"}], 
       "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"overlapRange", "=", "\[IndentingNewLine]", 
        RowBox[{"Which", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"Min", "[", 
             RowBox[{"data2", "[", 
              RowBox[{"[", 
               RowBox[{";;", ",", "1"}], "]"}], "]"}], "]"}], "<", 
            RowBox[{"Max", "[", 
             RowBox[{"data1", "[", 
              RowBox[{"[", 
               RowBox[{";;", ",", "1"}], "]"}], "]"}], "]"}]}], "&&", 
           RowBox[{
            RowBox[{"Max", "[", 
             RowBox[{"data2", "[", 
              RowBox[{"[", 
               RowBox[{";;", ",", "1"}], "]"}], "]"}], "]"}], ">", 
            RowBox[{"Max", "[", 
             RowBox[{"data1", "[", 
              RowBox[{"[", 
               RowBox[{";;", ",", "1"}], "]"}], "]"}], "]"}]}], "&&", 
           RowBox[{
            RowBox[{"Min", "[", 
             RowBox[{"data2", "[", 
              RowBox[{"[", 
               RowBox[{";;", ",", "1"}], "]"}], "]"}], "]"}], ">", 
            RowBox[{"Min", "[", 
             RowBox[{"data1", "[", 
              RowBox[{"[", 
               RowBox[{";;", ",", "1"}], "]"}], "]"}], "]"}]}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Min", "[", 
             RowBox[{"data2", "[", 
              RowBox[{"[", 
               RowBox[{";;", ",", "1"}], "]"}], "]"}], "]"}], ",", 
            RowBox[{"Max", "[", 
             RowBox[{"data1", "[", 
              RowBox[{"[", 
               RowBox[{";;", ",", "1"}], "]"}], "]"}], "]"}]}], "}"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"(*", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"Min", "[", 
               RowBox[{"data1", "[", 
                RowBox[{"[", 
                 RowBox[{";;", ",", "1"}], "]"}], "]"}], "]"}], "<", 
              RowBox[{"Max", "[", 
               RowBox[{"data2", "[", 
                RowBox[{"[", 
                 RowBox[{";;", ",", "1"}], "]"}], "]"}], "]"}]}], "&&", 
             "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"Max", "[", 
               RowBox[{"data2", "[", 
                RowBox[{"[", 
                 RowBox[{";;", ",", "1"}], "]"}], "]"}], "]"}], "<", 
              RowBox[{"Max", "[", 
               RowBox[{"data1", "[", 
                RowBox[{"[", 
                 RowBox[{";;", ",", "1"}], "]"}], "]"}], "]"}]}], "&&", 
             RowBox[{
              RowBox[{"Min", "[", 
               RowBox[{"data2", "[", 
                RowBox[{"[", 
                 RowBox[{";;", ",", "1"}], "]"}], "]"}], "]"}], "<", 
              RowBox[{"Min", "[", 
               RowBox[{"data1", "[", 
                RowBox[{"[", 
                 RowBox[{";;", ",", "1"}], "]"}], "]"}], "]"}]}]}], 
            "\[IndentingNewLine]", ","}], "*)"}], "\[IndentingNewLine]", 
          RowBox[{"(*", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Min", "[", 
               RowBox[{"data1", "[", 
                RowBox[{"[", 
                 RowBox[{";;", ",", "1"}], "]"}], "]"}], "]"}], ",", 
              RowBox[{"Max", "[", 
               RowBox[{"data2", "[", 
                RowBox[{"[", 
                 RowBox[{";;", ",", "1"}], "]"}], "]"}], "]"}]}], "}"}], 
            ","}], "*)"}], "\[IndentingNewLine]", "True", ",", 
          "\[IndentingNewLine]", 
          RowBox[{
          "Return", "[", "\"\<Error, no overlap, wrong order?\>\"", "]"}]}], 
         "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"overlap1", "=", 
        RowBox[{"Select", "[", 
         RowBox[{"data1", ",", 
          RowBox[{
           RowBox[{
            RowBox[{"overlapRange", "[", 
             RowBox[{"[", "1", "]"}], "]"}], "<", 
            RowBox[{"#", "[", 
             RowBox[{"[", "1", "]"}], "]"}], "<", 
            RowBox[{"overlapRange", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], "&"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"overlap2", "=", 
        RowBox[{"Select", "[", 
         RowBox[{"data2", ",", 
          RowBox[{
           RowBox[{
            RowBox[{"overlapRange", "[", 
             RowBox[{"[", "1", "]"}], "]"}], "<", 
            RowBox[{"#", "[", 
             RowBox[{"[", "1", "]"}], "]"}], "<", 
            RowBox[{"overlapRange", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], "&"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"overlappos", "=", 
        RowBox[{"Flatten", "[", 
         RowBox[{"Nearest", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"overlap1", "[", 
             RowBox[{"[", 
              RowBox[{";;", ",", "1"}], "]"}], "]"}], "\[Rule]", 
            RowBox[{"Range", "[", 
             RowBox[{"Length", "[", "overlap1", "]"}], "]"}]}], ",", 
           RowBox[{"overlap2", "[", 
            RowBox[{"[", 
             RowBox[{";;", ",", "1"}], "]"}], "]"}]}], "]"}], "]"}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"scale", "=", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Exp", "[", "c", "]"}], "/.", 
          RowBox[{
           RowBox[{"FindMinimum", "[", 
            RowBox[{
             RowBox[{"Norm", "[", 
              RowBox[{
               RowBox[{"overlap1", "[", 
                RowBox[{"[", 
                 RowBox[{"overlappos", ",", "2"}], "]"}], "]"}], "-", " ", 
               RowBox[{"overlap2", "[", 
                RowBox[{"[", 
                 RowBox[{";;", ",", "2"}], "]"}], "]"}], "-", "c"}], "]"}], 
             ",", "c"}], "]"}], "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], ")"}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"movingstdev", "=", 
        RowBox[{"MovingAverage", "[", 
         RowBox[{
          RowBox[{"MovingMap", "[", 
           RowBox[{"StandardDeviation", ",", 
            RowBox[{
             RowBox[{"overlap1", "[", 
              RowBox[{"[", 
               RowBox[{"overlappos", ",", "2"}], "]"}], "]"}], "-", " ", 
             RowBox[{"overlap2", "[", 
              RowBox[{"[", 
               RowBox[{";;", ",", "2"}], "]"}], "]"}], "+", 
             RowBox[{"Log", "[", "scale", "]"}]}], ",", "10"}], "]"}], ",", 
          "10"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"cutoffno", "=", 
        RowBox[{"First", "[", 
         RowBox[{"First", "[", 
          RowBox[{"Position", "[", 
           RowBox[{"movingstdev", ",", 
            RowBox[{"_", "?", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"#", ">", "0.01"}], "&"}], ")"}]}]}], "]"}], "]"}], 
         "]"}]}], ";", " ", 
       RowBox[{"(*", " ", 
        RowBox[{
         RowBox[{"was", " ", "0.1"}], ",", " ", 
         RowBox[{
         "but", " ", "gave", " ", "error", " ", "in", " ", "case", " ", "of", 
          " ", "already", " ", 
          RowBox[{"(", "almost", ")"}], " ", "overlapping", " ", "curves"}]}],
         " ", "*)"}], "\[IndentingNewLine]", 
       RowBox[{"cutoff", "=", 
        RowBox[{"Exp", "[", 
         RowBox[{"overlap2", "[", 
          RowBox[{"[", 
           RowBox[{"cutoffno", ",", "1"}], "]"}], "]"}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"Return", "[", "\[IndentingNewLine]", 
        RowBox[{"Sort", "[", "\[IndentingNewLine]", 
         RowBox[{"Join", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Select", "[", 
            RowBox[{"dataset1", ",", 
             RowBox[{
              RowBox[{
               RowBox[{"#", "[", 
                RowBox[{"[", "1", "]"}], "]"}], "<", "cutoff"}], "&"}]}], 
            "]"}], ",", 
           RowBox[{"dataset2", ".", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"1", ",", "0"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"0", ",", "scale"}], "}"}]}], "}"}]}]}], 
          "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", "]"}], 
        "\[IndentingNewLine]", "]"}]}]}], "\[IndentingNewLine]", 
     "]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.852781860752527*^9, 3.852781861400449*^9}, {
   3.852782427495048*^9, 3.852782432845196*^9}, {3.852782490522458*^9, 
   3.8527825233607388`*^9}, 3.852782757511119*^9, {3.8527828983994617`*^9, 
   3.852782923717813*^9}, {3.852783954273013*^9, 3.852783958577043*^9}, {
   3.852784217988599*^9, 3.852784232189209*^9}, {3.852784588124271*^9, 
   3.852784630667053*^9}, 3.8527849493876867`*^9, 3.852786296410307*^9, {
   3.852786445171461*^9, 3.8527864639719877`*^9}, 3.852786739567677*^9, {
   3.852787449131702*^9, 3.852787450514557*^9}, {3.853381975213027*^9, 
   3.853381976205628*^9}, {3.853382404274076*^9, 3.85338240456852*^9}, {
   3.85340333020494*^9, 3.853403408623046*^9}, {3.85340345847932*^9, 
   3.853403507151403*^9}, {3.853409529667601*^9, 3.8534095895008907`*^9}, {
   3.853409682647615*^9, 3.853409684334144*^9}, {3.853410131707053*^9, 
   3.85341017818784*^9}, {3.8538181053955297`*^9, 3.853818151693227*^9}, {
   3.8538238300771923`*^9, 3.853823831444284*^9}, {3.8544235682712183`*^9, 
   3.854423596844871*^9}, {3.8601372879871793`*^9, 3.860137300912186*^9}, {
   3.8601373341336937`*^9, 3.860137513416378*^9}, {3.8601377878238845`*^9, 
   3.860137825471859*^9}, 3.8601381170176554`*^9, {3.8601381527942257`*^9, 
   3.8601381554698157`*^9}, 3.860139314345042*^9, {3.8601396136069946`*^9, 
   3.860139637809037*^9}, {3.860140274802857*^9, 3.8601402881469436`*^9}, {
   3.8601403266498127`*^9, 3.860140345820403*^9}, {3.860140410589032*^9, 
   3.860140446255523*^9}, {3.8601404885987186`*^9, 3.8601405253716545`*^9}, {
   3.8601405888823967`*^9, 3.8601406208542633`*^9}, {3.860140651384527*^9, 
   3.86014076017659*^9}, {3.8601408369383373`*^9, 3.8601408546914597`*^9}, {
   3.8601412665787563`*^9, 3.860141297881263*^9}, 3.8629073718138065`*^9, {
   3.8636846731243887`*^9, 3.863684721178178*^9}, {3.8636849961195316`*^9, 
   3.8636850169326954`*^9}, {3.863685081135563*^9, 3.8636851178496304`*^9}, {
   3.863685275732274*^9, 3.863685280648721*^9}},
 CellLabel->"In[15]:=",ExpressionUUID->"f2858960-ee9b-434f-ab6f-b0967ca77d38"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"BG18_10.0042\"\>", ",", "\<\"BG18_1.504\"\>", 
   ",", "\<\"BG18_30.7138\"\>", ",", "\<\"BG19_10.004\"\>", 
   ",", "\<\"BG19_30.7138\"\>", ",", "\<\"BG20_10.0042\"\>", 
   ",", "\<\"BG20_1.504\"\>", ",", "\<\"BG20_30.7138\"\>", 
   ",", "\<\"BG21_10.0042\"\>", ",", "\<\"BG21_1.504\"\>", 
   ",", "\<\"BG21_30.7138\"\>", ",", "\<\"BG22_10.0042\"\>", 
   ",", "\<\"BG22_1.504\"\>", ",", "\<\"BG22_30.7138\"\>", 
   ",", "\<\"BG23_10.0042\"\>", ",", "\<\"BG23_1.504\"\>", 
   ",", "\<\"BG23_30.7138\"\>", ",", "\<\"BG24_10.0042\"\>", 
   ",", "\<\"BG24_1.504\"\>", ",", "\<\"BG24_30.7138\"\>", 
   ",", "\<\"BG25_10.0042\"\>", ",", "\<\"BG25_1.504\"\>", 
   ",", "\<\"BG25_30.7138\"\>", ",", "\<\"BG26_10.0042\"\>", 
   ",", "\<\"BG26_1.504\"\>", ",", "\<\"BG26_30.7138\"\>", 
   ",", "\<\"BG31_10.0042\"\>", ",", "\<\"BG31_1.504\"\>", 
   ",", "\<\"BG31_30.7138\"\>", ",", "\<\"BG34_10.0042\"\>", 
   ",", "\<\"BG34_1.504\"\>", ",", "\<\"BG34_30.7138\"\>", 
   ",", "\<\"BG35_10.0042\"\>", ",", "\<\"BG35_1.504\"\>", 
   ",", "\<\"BG35_30.7138\"\>", ",", "\<\"BG36_10.0042\"\>", 
   ",", "\<\"BG36_1.504\"\>", ",", "\<\"BG36_30.7138\"\>", 
   ",", "\<\"BG37_10.0042\"\>", ",", "\<\"BG37_1.504\"\>", 
   ",", "\<\"BG37_30.7138\"\>", ",", "\<\"BG38_10.0042\"\>", 
   ",", "\<\"BG38_1.504\"\>", ",", "\<\"BG38_30.7138\"\>", 
   ",", "\<\"C10_10.0042\"\>", ",", "\<\"C10_1.504\"\>", 
   ",", "\<\"C10_30.7138\"\>", ",", "\<\"C1_10.004\"\>", 
   ",", "\<\"C11_10.0042\"\>", ",", "\<\"C11_1.504\"\>", 
   ",", "\<\"C11_2_10.0042\"\>", ",", "\<\"C11_2_1.504\"\>", 
   ",", "\<\"C11_2_30.7138\"\>", ",", "\<\"C11_30.7138\"\>", 
   ",", "\<\"C1_1.504\"\>", ",", "\<\"C12_10.0042\"\>", 
   ",", "\<\"C12_1.504\"\>", ",", "\<\"C12_30.7138\"\>", 
   ",", "\<\"C1_30.7138\"\>", ",", "\<\"C13_10.0042\"\>", 
   ",", "\<\"C13_1.504\"\>", ",", "\<\"C13_30.7138\"\>", 
   ",", "\<\"C14_10.0042\"\>", ",", "\<\"C14_1.504\"\>", 
   ",", "\<\"C14_30.7138\"\>", ",", "\<\"C15_10.0042\"\>", 
   ",", "\<\"C15_1.504\"\>", ",", "\<\"C15_30.7138\"\>", 
   ",", "\<\"C16_10.0042\"\>", ",", "\<\"C16_1.504\"\>", 
   ",", "\<\"C16_30.7138\"\>", ",", "\<\"C17_10.0042\"\>", 
   ",", "\<\"C17_1.504\"\>", ",", "\<\"C17_30.7138\"\>", 
   ",", "\<\"C18_10.0042\"\>", ",", "\<\"C18_1.504\"\>", 
   ",", "\<\"C18_30.7138\"\>", ",", "\<\"C19_10.0042\"\>", 
   ",", "\<\"C19_1.504\"\>", ",", "\<\"C19_30.7138\"\>", 
   ",", "\<\"C20_10.0042\"\>", ",", "\<\"C20_1.504\"\>", 
   ",", "\<\"C20_30.7138\"\>", ",", "\<\"C2_10.0042\"\>", 
   ",", "\<\"C21_10.0042\"\>", ",", "\<\"C21_1.504\"\>", 
   ",", "\<\"C21_30.7138\"\>", ",", "\<\"C2_1.504\"\>", 
   ",", "\<\"C22_10.0042\"\>", ",", "\<\"C22_1.504\"\>", 
   ",", "\<\"C22_30.7138\"\>", ",", "\<\"C2_30.7138\"\>", 
   ",", "\<\"C23_10.0042\"\>", ",", "\<\"C23_1.504\"\>", 
   ",", "\<\"C23_30.7138\"\>", ",", "\<\"C24_10.0042\"\>", 
   ",", "\<\"C24_1.504\"\>", ",", "\<\"C24_30.7138\"\>", 
   ",", "\<\"C25_10.0042\"\>", ",", "\<\"C25_1.504\"\>", 
   ",", "\<\"C25_30.7138\"\>", ",", "\<\"C26_10.0042\"\>", 
   ",", "\<\"C26_1.504\"\>", ",", "\<\"C26_30.7138\"\>", 
   ",", "\<\"C27_10.0042\"\>", ",", "\<\"C27_1.504\"\>", 
   ",", "\<\"C27_30.7138\"\>", ",", "\<\"C28_10.0042\"\>", 
   ",", "\<\"C28_1.504\"\>", ",", "\<\"C28_30.7138\"\>", 
   ",", "\<\"C29_10.0042\"\>", ",", "\<\"C29_1.504\"\>", 
   ",", "\<\"C29_30.7138\"\>", ",", "\<\"C30_10.0042\"\>", 
   ",", "\<\"C30_1.504\"\>", ",", "\<\"C30_30.7138\"\>", 
   ",", "\<\"C3_10.0042\"\>", ",", "\<\"C31_10.0042\"\>", 
   ",", "\<\"C31_1.504\"\>", ",", "\<\"C31_30.7138\"\>", 
   ",", "\<\"C3_1.504\"\>", ",", "\<\"C32_10.0042\"\>", 
   ",", "\<\"C32_1.504\"\>", ",", "\<\"C32_30.7138\"\>", 
   ",", "\<\"C3_30.7138\"\>", ",", "\<\"C33_10.0042\"\>", 
   ",", "\<\"C33_1.504\"\>", ",", "\<\"C33_30.7138\"\>", 
   ",", "\<\"C4_10.0042\"\>", ",", "\<\"C4_1.504\"\>", 
   ",", "\<\"C4_30.7138\"\>", ",", "\<\"C5_10.0042\"\>", 
   ",", "\<\"C5_1.504\"\>", ",", "\<\"C5_30.7138\"\>", 
   ",", "\<\"C8_10.0042\"\>", ",", "\<\"C8_1.504\"\>", 
   ",", "\<\"C8_30.7138\"\>", ",", "\<\"C9_10.0042\"\>", 
   ",", "\<\"C9_1.504\"\>", ",", "\<\"C9_30.7138\"\>", 
   ",", "\<\"Empty_Cap_10.0042\"\>", ",", "\<\"Empty_Cap_1.504\"\>", 
   ",", "\<\"Empty_Cap_30.7138\"\>"}], "}"}]], "Output",
 CellChangeTimes->{{3.843291116410307*^9, 3.843291130190617*^9}, {
   3.8432911719097652`*^9, 3.843291185978409*^9}, 3.843291220560841*^9, {
   3.8432912704296637`*^9, 3.84329127392964*^9}, 3.843291320135066*^9, {
   3.8432913518879747`*^9, 3.8432913767025137`*^9}, {3.84329145300187*^9, 
   3.843291477899846*^9}, {3.843291512572294*^9, 3.843291534673026*^9}, 
   3.8432928114247313`*^9, 3.843292945133399*^9, {3.843293186383741*^9, 
   3.843293193473956*^9}, 3.843293608109157*^9, 3.843293645515916*^9, {
   3.843293716052813*^9, 3.843293730759082*^9}, {3.843293761080804*^9, 
   3.843293772865118*^9}, 3.8432938713954144`*^9, {3.84329471860441*^9, 
   3.8432947251573477`*^9}, 3.843294771162959*^9, 3.843294885917644*^9, 
   3.843295151895554*^9, 3.8432956501750383`*^9, 3.843296152599977*^9, {
   3.843296189871492*^9, 3.843296191243095*^9}, 3.84329659605822*^9, 
   3.843296864247712*^9, 3.843297654343287*^9, 3.843297684687933*^9, 
   3.843298780405675*^9, 3.8432988461417847`*^9, 3.843299816472809*^9, 
   3.852779404882422*^9, {3.852782926379023*^9, 3.852782939958962*^9}, 
   3.852783082585239*^9, 3.85278423842143*^9, 3.852784635998056*^9, 
   3.852784774684959*^9, 3.85278495816325*^9, 3.852785644257989*^9, 
   3.852786584046872*^9, 3.852787231457491*^9, 3.8527874512893887`*^9, 
   3.8528624946437807`*^9, 3.8533813666181393`*^9, 3.853381473051558*^9, 
   3.853382002859495*^9, {3.853382366117324*^9, 3.8533824068816853`*^9}, 
   3.853382447973559*^9, 3.853402237496472*^9, {3.8534035050061913`*^9, 
   3.853403520153386*^9}, {3.853409576568863*^9, 3.853409590687502*^9}, 
   3.853409686569212*^9, 3.853410179540357*^9, 3.85346909235686*^9, {
   3.853496221708645*^9, 3.853496230454815*^9}, 3.8534962722710114`*^9, 
   3.8534995714970713`*^9, 3.8534996217654676`*^9, {3.8534998537977457`*^9, 
   3.853499861198127*^9}, 3.853817842905547*^9, 3.8538182330499973`*^9, 
   3.853823854615374*^9, 3.853824682278778*^9, 3.8538248698359203`*^9, 
   3.8538330740724907`*^9, 3.853836452527369*^9, 3.853838538520102*^9, 
   3.854072553798176*^9, 3.854091674337735*^9, 3.854098459639974*^9, 
   3.8544207575313673`*^9, {3.854423578230679*^9, 3.854423602648951*^9}, 
   3.8601380332758555`*^9, 3.8601397073699045`*^9, 3.8601408681378775`*^9, 
   3.860141165553254*^9, 3.8617630814145107`*^9, 3.8617632495409374`*^9, 
   3.86194321925034*^9, 3.861950293500869*^9, 3.862109428120537*^9, 
   3.862204577976136*^9, 3.8859712433884926`*^9, 3.8859717023665004`*^9, 
   3.885973538318736*^9, 3.8871822213001337`*^9, 3.888309647401424*^9, 
   3.888309685383727*^9, 3.8883100772164288`*^9, 3.889001634921618*^9, 
   3.889060229645113*^9, 3.889064545330427*^9, 3.88908010527439*^9, 
   3.88908177519516*^9, 3.889082725590596*^9, 3.8890843099944553`*^9, 
   3.889498714652341*^9, 3.889499954222128*^9, 3.8895040850259047`*^9, 
   3.88966850980521*^9, 3.890202669873102*^9, 3.89097689186923*^9, 
   3.8914131817881813`*^9, 3.8914901650050025`*^9, 3.8919178772682314`*^9, 
   3.891918256701417*^9, 3.8926093273920903`*^9, 3.9023135005532465`*^9, 
   3.9041237961913223`*^9, 3.906015716956253*^9, 3.913785637224742*^9, 
   3.915692645386676*^9, 3.9156927457356205`*^9, 3.9156928168490057`*^9, 
   3.9170004285639396`*^9, 3.9174149905955286`*^9, 3.9174163042166233`*^9, 
   3.9174218886615343`*^9, 3.9174234894375935`*^9},
 CellLabel->"Out[21]=",ExpressionUUID->"f9b6c3c3-9552-4f46-b682-1e83f803b85c"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Data fitting commands", "Subsection",
 CellChangeTimes->{{3.853833173909893*^9, 3.85383317510979*^9}, {
  3.854423364858252*^9, 
  3.854423369840681*^9}},ExpressionUUID->"9ecbbbc5-8b8f-4847-b220-\
8094510e4a4e"],

Cell["\<\
importing (or calculating -- which is very slow --, then saving) a table with \
all scattering patterns for a range of q, l, and r\
\>", "Text",
 CellChangeTimes->{{3.889001751397065*^9, 3.8890017945493183`*^9}, {
  3.8894989004771748`*^9, 
  3.8894989080000873`*^9}},ExpressionUUID->"1226fcdb-2e55-460d-933b-\
f363aeb6389f"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"qmin", "=", 
    RowBox[{"-", "3"}]}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"log", " ", "scale", " ", 
    RowBox[{"10", "^", "x"}]}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"qmax", "=", "1"}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"log", " ", "scale", " ", 
    RowBox[{"10", "^", "x"}]}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"qstep", "=", "0.02"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"qlist", "=", 
    RowBox[{"10", "^", 
     RowBox[{"Range", "[", 
      RowBox[{"qmin", ",", "qmax", ",", "qstep"}], "]"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"qlistslope", "=", 
    RowBox[{"Exp", "[", 
     RowBox[{"MovingAverage", "[", 
      RowBox[{
       RowBox[{"Log", "[", "qlist", "]"}], ",", "2"}], "]"}], "]"}]}], ";"}], 
  " ", 
  RowBox[{"(*", 
   RowBox[{"slope", "-", 
    RowBox[{
    "fitting", " ", "is", " ", "done", " ", "using", " ", "log", " ", 
     "scale"}]}], "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"lengthmin", "=", 
    RowBox[{"-", "1"}]}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"log", " ", "scale", " ", 
    RowBox[{"10", "^", "x"}]}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"lengthmax", "=", "3"}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"log", " ", "scale", " ", 
    RowBox[{"10", "^", "x"}]}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"lengthstep", "=", "0.02"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"lengths", "=", 
    RowBox[{"10", "^", 
     RowBox[{"Range", "[", 
      RowBox[{"lengthmin", ",", "lengthmax", ",", "lengthstep"}], "]"}]}]}], 
   ";"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"radiusmin", "=", "1"}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"log", " ", "scale", " ", 
    RowBox[{"10", "^", "x"}]}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"radiusmax", "=", "4"}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"log", " ", "scale", " ", 
    RowBox[{"10", "^", "x"}]}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"radiusstep", "=", "0.02"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"radii", "=", 
    RowBox[{"10", "^", 
     RowBox[{"Range", "[", 
      RowBox[{"radiusmin", ",", "radiusmax", ",", "radiusstep"}], "]"}]}]}], 
   ";"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Length", "[", "lengths", "]"}], "*", 
   RowBox[{"Length", "[", "radii", "]"}]}], " ", 
  RowBox[{"(*", 
   RowBox[{
   "number", " ", "of", " ", "combinations", " ", "of", " ", "L", " ", "and", 
    " ", "R"}], "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Define", " ", "a", " ", "form", " ", "factor", " ", "for", " ", "disk", 
    " ", "with", " ", "radius", " ", "L", " ", "and", " ", "length", " ", "R",
     " ", 
    RowBox[{"(", 
     RowBox[{"Pedersen", " ", "1997"}], ")"}]}], " ", "*)"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"P11", "[", 
     RowBox[{"q_", ",", "R_", ",", "L_"}], "]"}], ":=", 
    RowBox[{"Quiet", "[", 
     RowBox[{"NIntegrate", "[", 
      RowBox[{
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           FractionBox[
            RowBox[{"2", " ", 
             RowBox[{"BesselJ", "[", 
              RowBox[{"1", ",", 
               RowBox[{"q", " ", "R", " ", 
                RowBox[{"Sin", "[", "\[Alpha]", "]"}]}]}], "]"}]}], 
            RowBox[{"q", " ", "R", " ", 
             RowBox[{"Sin", "[", "\[Alpha]", "]"}]}]], " ", 
           FractionBox[
            RowBox[{"Sin", "[", 
             FractionBox[
              RowBox[{"q", " ", "L", " ", 
               RowBox[{"Cos", "[", "\[Alpha]", "]"}]}], "2"], "]"}], 
            FractionBox[
             RowBox[{"q", " ", "L", " ", 
              RowBox[{"Cos", "[", "\[Alpha]", "]"}]}], "2"]]}], ")"}], "2"], 
        RowBox[{"Sin", "[", "\[Alpha]", "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Alpha]", ",", "0", ",", 
         FractionBox["\[Pi]", "2"]}], "}"}]}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"filename", "=", 
    RowBox[{"\"\<double polydisp data \>\"", "<>", 
     RowBox[{"ToString", "[", 
      RowBox[{"Hash", "[", 
       RowBox[{"{", 
        RowBox[{"qlist", ",", "lengths", ",", "radii"}], "}"}], "]"}], "]"}], 
     "<>", "\"\<.mx\>\""}]}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Unfortunately", " ", "looks", " ", "like", " ", "this", " ", "hash", " ",
      "code", " ", "is", " ", "computer", " ", "specific"}], ",", " ", 
    RowBox[{
    "so", " ", "might", " ", "need", " ", "to", " ", "change", " ", "the", 
     " ", "file", " ", "name", " ", "of", " ", "the", " ", "existing", " ", 
     "table", " ", "to", " ", "this", " ", "name", " ", "if", " ", "you", " ",
      "want", " ", "to", " ", "reuse", " ", 
     RowBox[{"it", "."}]}]}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"filename", "=", 
   RowBox[{"FileNameJoin", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"NotebookDirectory", "[", "]"}], ",", "filename"}], "}"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
  "filename", " ", "=", " ", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"If", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"FileExistsQ", "[", "filename", "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"dataAllLengths", "=", 
       RowBox[{"<<", 
        RowBox[{"(", "filename", ")"}]}]}], ";"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"SetSharedVariable", "[", "j", "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"j", "=", "0"}], ";", "\[IndentingNewLine]", 
      RowBox[{"Monitor", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"dataAllLengths", "=", 
          RowBox[{"Quiet", "[", "\[IndentingNewLine]", 
           RowBox[{"ParallelTable", "[", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"Table", "[", "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{
                RowBox[{"j", "++"}], ";", "\[IndentingNewLine]", 
                RowBox[{"P11", "[", 
                 RowBox[{"qlist", ",", "radius", ",", "length"}], "]"}]}], 
               ",", "\[IndentingNewLine]", 
               RowBox[{"{", 
                RowBox[{"length", ",", "lengths"}], "}"}]}], 
              "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{"radius", ",", "radii"}], "}"}]}], 
            "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", "]"}]}], 
         ";"}], ",", "\[IndentingNewLine]", "j"}], "\[IndentingNewLine]", 
       "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"dataAllLengths", ">>", 
       RowBox[{"(", "filename", ")"}]}]}]}], "\[IndentingNewLine]", "]"}]}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "definition", " ", "of", " ", "probability", " ", "density", " ", 
    "function", " ", "and", " ", "function", " ", "to", " ", "calculate", " ",
     "intensities", " ", "with", " ", "both", " ", "L", " ", "and", " ", "R", 
    " ", 
    RowBox[{"unknown", "."}]}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"probfunc", "[", 
    RowBox[{
    "\[Mu]l_", ",", "\[Sigma]l_", ",", "\[Mu]r_", ",", "\[Sigma]r_", ",", 
     "l_", ",", "r_"}], "]"}], "=", "\[IndentingNewLine]", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"PDF", "[", 
      RowBox[{
       RowBox[{"LogMultinormalDistribution", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\[Mu]l", ",", "\[Mu]r"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             SuperscriptBox["\[Sigma]l", "2"], ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", 
             SuperscriptBox["\[Sigma]r", "2"]}], "}"}]}], "}"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"l", ",", "r"}], "}"}]}], "]"}], ",", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"l", ">", "0"}], ",", 
        RowBox[{"r", ">", "0"}]}], "}"}]}]}], "]"}]}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Calculate", " ", "intensities", " ", "for", " ", "the", " ", "platelets", 
    " ", "based", " ", "on", " ", "the", " ", "probability", " ", 
    "distributions", " ", "obtained", " ", "with", " ", "the", " ", "form", 
    " ", "factor", " ", 
    RowBox[{"fit", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"note", ";", " ", 
    RowBox[{
     RowBox[{
     "this", " ", "intensity", " ", "is", " ", "NOT", " ", "corrected", " ", 
      "for", " ", "the", " ", 
      RowBox[{"volume", "^", "2"}]}], "-", 
     RowBox[{
     "dependence", " ", "of", " ", "scattering", " ", "intensity", " ", 
      RowBox[{"(", 
       RowBox[{
       "can", " ", "be", " ", "easily", " ", "added", " ", "if", " ", "you", 
        " ", 
        RowBox[{"want", "!"}]}], ")"}]}]}]}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"calculateIntensitiesLR", "[", 
     RowBox[{
      RowBox[{"\[Mu]l_", "?", "NumberQ"}], ",", 
      RowBox[{"\[Sigma]l_", "?", "NumberQ"}], ",", 
      RowBox[{"\[Mu]r_", "?", "NumberQ"}], ",", 
      RowBox[{"\[Sigma]r_", "?", "NumberQ"}]}], "]"}], ":=", 
    "\[IndentingNewLine]", 
    RowBox[{"Block", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"probabilities", ",", "data"}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"probabilities", "=", "\[IndentingNewLine]", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["10", 
              RowBox[{
               RowBox[{"Log10", "[", "r", "]"}], "+", 
               RowBox[{"radiusstep", "/", "2"}]}]], "-", 
             SuperscriptBox["10", 
              RowBox[{
               RowBox[{"Log10", "[", "r", "]"}], "-", 
               RowBox[{"radiusstep", "/", "2"}]}]]}], ")"}], "*", 
           "\[IndentingNewLine]", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["10", 
              RowBox[{
               RowBox[{"Log10", "[", "l", "]"}], "+", 
               RowBox[{"lengthstep", "/", "2"}]}]], "-", 
             SuperscriptBox["10", 
              RowBox[{
               RowBox[{"Log10", "[", "l", "]"}], "-", 
               RowBox[{"lengthstep", "/", "2"}]}]]}], ")"}], "*", 
           "\[IndentingNewLine]", 
           RowBox[{"probfunc", "[", 
            RowBox[{
            "\[Mu]l", ",", "\[Sigma]l", ",", "\[Mu]r", ",", "\[Sigma]r", ",", 
             "l", ",", "r"}], "]"}]}], ",", "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{"r", ",", "radii"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"l", ",", "lengths"}], "}"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"probabilities", "=", 
        RowBox[{"probabilities", "/", 
         RowBox[{"Total", "[", 
          RowBox[{"Flatten", "[", "probabilities", "]"}], "]"}]}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"data", "=", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"qlist", ",", 
           RowBox[{"Total", "[", "\[IndentingNewLine]", 
            RowBox[{"Table", "[", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{
               RowBox[{"probabilities", "[", 
                RowBox[{"[", "i", "]"}], "]"}], ".", 
               RowBox[{"dataAllLengths", "[", 
                RowBox[{"[", "i", "]"}], "]"}]}], ",", " ", 
              RowBox[{"(*", " ", 
               RowBox[{
                RowBox[{
                "why", " ", "do", " ", "we", " ", "not", " ", "need", " ", 
                 "to", " ", "call", " ", "the", " ", "form", " ", "factor", 
                 " ", 
                 RowBox[{"again", "?", " ", "Because"}], " ", "we", " ", 
                 "read", " ", "the", " ", "previously", " ", "calculated", 
                 " ", "table", " ", "I", " ", 
                 RowBox[{"think", ".", " ", "But"}], " ", 
                 RowBox[{"shouldn", "'"}], "t", " ", "we", " ", "correct", 
                 " ", "for", " ", "the", " ", "form", " ", "factor", " ", 
                 "vs", " ", "intensity", " ", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"i", ".", "e", ".", " ", "multiplying"}], " ", 
                    "with", " ", "A_dis"}], " ", "=", " ", 
                    RowBox[{"Pi", " ", 
                    RowBox[{"R", "^", "2"}]}]}], ")"}], "?"}]}], " ", "->", 
                " ", 
                RowBox[{
                "indeed", " ", "this", " ", "is", " ", "the", " ", "volume", 
                 " ", "dependence", " ", "of", " ", "the", " ", "scattering", 
                 " ", "function", " ", "that", " ", "Mark", " ", "is", " ", 
                 "refering", " ", "to", " ", 
                 RowBox[{"above", "."}]}]}], " ", "*)"}], 
              "\[IndentingNewLine]", 
              RowBox[{"{", 
               RowBox[{"i", ",", 
                RowBox[{"Length", "[", "probabilities", "]"}]}], "}"}]}], 
             "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", "]"}]}], 
          "}"}], "\[Transpose]"}]}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"Return", "[", "data", "]"}]}]}], "\[IndentingNewLine]", 
     "]"}]}], ";"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{
  3.853833992055169*^9, {3.853838966450965*^9, 3.853838966553301*^9}, {
   3.8544234235752993`*^9, 3.854423436127577*^9}, {3.854430087163003*^9, 
   3.854430130510928*^9}, {3.854430203830633*^9, 3.854430219131062*^9}, {
   3.8601385420212803`*^9, 3.860138638056221*^9}, {3.8601386828025064`*^9, 
   3.860138692836401*^9}, {3.8619498070714016`*^9, 3.861949810669832*^9}, {
   3.864111368481957*^9, 3.864111381547614*^9}, {3.8641119129600077`*^9, 
   3.864111933466826*^9}, {3.86411198099782*^9, 3.8641120377855062`*^9}, {
   3.864112243724079*^9, 3.8641122604900866`*^9}, {3.864112766219705*^9, 
   3.86411278769474*^9}, {3.8641135528767495`*^9, 3.8641135674698086`*^9}, {
   3.8641136364748583`*^9, 3.8641136872689133`*^9}, {3.864115609508887*^9, 
   3.864115696314577*^9}, {3.864115732636894*^9, 3.864115830964185*^9}, {
   3.8641158807267537`*^9, 3.8641158812495947`*^9}, {3.8641159142672977`*^9, 
   3.864115966691824*^9}, {3.8641160299919057`*^9, 3.8641160563528504`*^9}, {
   3.8641161004319696`*^9, 3.8641161468625154`*^9}, {3.8641161798404274`*^9, 
   3.8641161881638513`*^9}, {3.864116300781921*^9, 3.864116303316224*^9}, {
   3.864117598850899*^9, 3.864117610456077*^9}, {3.864117641542405*^9, 
   3.8641176697889366`*^9}, {3.864180413527955*^9, 3.864180439734521*^9}, {
   3.8641804809675617`*^9, 3.8641805484890027`*^9}, {3.864439294957782*^9, 
   3.8644393039048176`*^9}, {3.8644393915786576`*^9, 3.864439422827739*^9}, {
   3.864439453939878*^9, 3.864439469354518*^9}, {3.864439507094865*^9, 
   3.864439508154552*^9}, 3.8644397191828737`*^9, {3.8644398454503803`*^9, 
   3.8644398477143235`*^9}, {3.8644399339387035`*^9, 3.86443994606491*^9}, {
   3.886064903615081*^9, 3.8860649365245705`*^9}, {3.8860649824235754`*^9, 
   3.886065042163972*^9}, {3.8860654296691275`*^9, 3.8860654298245497`*^9}, {
   3.8860658521704564`*^9, 3.886065874983266*^9}, {3.886066040165041*^9, 
   3.886066041373247*^9}, {3.8860666771353765`*^9, 3.8860666867852397`*^9}, {
   3.887182510322879*^9, 3.887182533881962*^9}, 3.887182594924156*^9, {
   3.888309810352276*^9, 3.8883099090736856`*^9}, 3.888309979546259*^9, {
   3.889001517107656*^9, 3.889001521496806*^9}, 3.8890015518214397`*^9, {
   3.8890016534686737`*^9, 3.8890016557649727`*^9}, {3.8890018189941072`*^9, 
   3.8890019390049477`*^9}, {3.889001975497669*^9, 3.88900205859529*^9}, {
   3.8890029285899467`*^9, 3.889002953302465*^9}, {3.889061053677486*^9, 
   3.889061062588866*^9}, {3.889077630726709*^9, 3.889077637427123*^9}, {
   3.8890777314446993`*^9, 3.889077747654249*^9}, {3.88907998107436*^9, 
   3.889079982089085*^9}, {3.889080034422716*^9, 3.8890801182358418`*^9}, {
   3.889080169489069*^9, 3.889080169576085*^9}, {3.88949949386611*^9, 
   3.889499567193898*^9}, {3.8894998864287863`*^9, 3.8894998890429115`*^9}, {
   3.889500147504761*^9, 3.8895001771365824`*^9}, {3.8895002362490377`*^9, 
   3.8895002555469923`*^9}, 3.8896807810308504`*^9, {3.8896808952666397`*^9, 
   3.889680897469507*^9}, 3.8896809885482616`*^9, {3.889681435463972*^9, 
   3.889681467825818*^9}, {3.889683285411501*^9, 3.8896833249263334`*^9}, {
   3.8896836624629545`*^9, 3.889683726861018*^9}, {3.889683767007558*^9, 
   3.8896837811495934`*^9}, {3.8909840270444803`*^9, 3.890984036295034*^9}, 
   3.890984239308541*^9, {3.905228365161728*^9, 3.905228365907522*^9}, {
   3.9152684901242714`*^9, 3.9152685116505303`*^9}},
 CellLabel->"In[23]:=",ExpressionUUID->"904598d3-3be1-4b29-9812-e84f814faf5c"],

Cell[BoxData["30351"], "Output",
 CellChangeTimes->{3.9060157171264696`*^9, 3.9137856373452454`*^9, 
  3.9152684921369486`*^9, 3.915692656837305*^9, 3.915692750939785*^9, 
  3.917000428609875*^9, 3.917414997462593*^9, 3.917416304292955*^9, 
  3.917421888917045*^9, 3.9174234895440917`*^9},
 CellLabel->"Out[36]=",ExpressionUUID->"24a2b4f1-f326-4e5e-8283-1293f6ce0c8d"],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"\[Mu]l", "-", 
         RowBox[{"Log", "[", "l", "]"}]}], ")"}], "2"], 
      RowBox[{"2", " ", 
       SuperscriptBox["\[Sigma]l", "2"]}]]}], "-", 
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"\[Mu]r", "-", 
        RowBox[{"Log", "[", "r", "]"}]}], ")"}], "2"], 
     RowBox[{"2", " ", 
      SuperscriptBox["\[Sigma]r", "2"]}]]}]], 
  RowBox[{"2", " ", "l", " ", "\[Pi]", " ", "r", " ", 
   SqrtBox[
    RowBox[{
     SuperscriptBox["\[Sigma]l", "2"], " ", 
     SuperscriptBox["\[Sigma]r", "2"]}]]}]]], "Output",
 CellChangeTimes->{3.9060157171264696`*^9, 3.9137856373452454`*^9, 
  3.9152684921369486`*^9, 3.915692656837305*^9, 3.915692750939785*^9, 
  3.917000428609875*^9, 3.917414997462593*^9, 3.917416304292955*^9, 
  3.917421888917045*^9, 3.9174235025333796`*^9},
 CellLabel->"Out[41]=",ExpressionUUID->"8c43dfeb-5a37-4948-91ab-304090a8d307"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Note", ":", " ", 
     RowBox[{
     "the", " ", "initial", " ", "values", " ", "are", " ", "optional"}]}], 
    ";", " ", 
    RowBox[{
    "if", " ", "you", " ", "omit", " ", "them", " ", "the", " ", "value", " ",
      "after", " ", 
     RowBox[{"the", " ", ":", " ", 
      RowBox[{"will", " ", "be", " ", 
       RowBox[{"assumed", ".", " ", "Fit"}], " ", "slopes", " ", "with", " ", 
       "this", " ", "discrete", " ", "full", " ", "form", " ", "factor", " ", 
       "\"\<function\>\""}]}]}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"fitSlopeLR", "[", 
     RowBox[{"data_", ",", 
      RowBox[{"\[Mu]linitial_", ":", 
       RowBox[{"Log", "[", "30.", "]"}]}], ",", 
      RowBox[{"\[Sigma]linitial_", ":", "0.5"}], ",", 
      RowBox[{"\[Mu]rinitial_", ":", 
       RowBox[{"Log", "[", "250.", "]"}]}], ",", 
      RowBox[{"\[Sigma]rinitial_", ":", "0.5"}], ",", " ", 
      RowBox[{"binfactor_", ":", "0.15"}]}], "]"}], ":=", 
    "\[IndentingNewLine]", 
    RowBox[{"Block", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"dataSlope", "=", 
         RowBox[{"slope", "[", 
          RowBox[{"data", ",", "binfactor"}], "]"}]}], ",", 
        "\[IndentingNewLine]", "qListDataSlope"}], "\[IndentingNewLine]", 
       "}"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"qListDataSlope", "=", 
        RowBox[{"dataSlope", "[", 
         RowBox[{"[", 
          RowBox[{";;", ",", "1"}], "]"}], "]"}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"minfuncslopeLR", "[", 
         RowBox[{
          RowBox[{"\[Mu]l_", "?", "NumberQ"}], ",", 
          RowBox[{"\[Sigma]l_", "?", "NumberQ"}], ",", 
          RowBox[{"\[Mu]r_", "?", "NumberQ"}], ",", 
          RowBox[{"\[Sigma]r_", "?", "NumberQ"}]}], "]"}], ":=", 
        RowBox[{
         RowBox[{"Norm", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"slope", "[", 
             RowBox[{"calculateIntensitiesLR", "[", 
              RowBox[{
              "\[Mu]l", ",", "\[Sigma]l", ",", "\[Mu]r", ",", "\[Sigma]r"}], 
              "]"}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{"Flatten", "[", 
               RowBox[{"Nearest", "[", 
                RowBox[{
                 RowBox[{"qlistslope", "\[Rule]", "\"\<Index\>\""}], ",", 
                 "qListDataSlope"}], "]"}], "]"}], ",", "2"}], "]"}], "]"}], 
           "-", "\[IndentingNewLine]", 
           RowBox[{"dataSlope", "[", 
            RowBox[{"[", 
             RowBox[{";;", ",", "2"}], "]"}], "]"}]}], "]"}], "[", 
         "\"\<Value\>\"", "]"}]}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"fmfSLR", "=", 
        RowBox[{"FindMinimum", "[", "\[IndentingNewLine]", 
         RowBox[{"(*", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"minfuncslopeLR", "[", 
             RowBox[{
             "\[Mu]l", ",", "\[Sigma]l", ",", "\[Mu]r", ",", "\[Sigma]r"}], 
             "]"}], " ", ",", " ", 
            RowBox[{"\[Mu]l", " ", ">", " ", "0"}], ",", " ", 
            RowBox[{"\[Sigma]l", " ", ">", " ", "0"}], ",", " ", 
            RowBox[{"\[Mu]r", " ", ">", " ", "0"}], ",", " ", 
            RowBox[{"\[Sigma]r", ">", "0"}]}], " ", "}"}], "*)"}], " ", 
         RowBox[{"(*", " ", 
          RowBox[{"constraint", ":", " ", 
           RowBox[{"sigma", " ", ">", " ", "0"}]}], "*)"}], 
         "\[IndentingNewLine]", 
         RowBox[{"(*", 
          RowBox[{"minfuncslopeLR", "[", 
           RowBox[{
           "\[Mu]l", ",", "\[Sigma]l", ",", "\[Mu]r", ",", "\[Sigma]r"}], 
           "]"}], "*)"}], "  ", 
         RowBox[{"(*", " ", "default", " ", "*)"}], "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"minfuncslopeLR", "[", 
           RowBox[{
            RowBox[{"Abs", "[", "\[Mu]l", "]"}], ",", 
            RowBox[{"Abs", "[", "\[Sigma]l", "]"}], ",", 
            RowBox[{"Abs", "[", "\[Mu]r", "]"}], ",", 
            RowBox[{"Abs", "[", "\[Sigma]r", "]"}]}], " ", 
           RowBox[{"(*", " ", 
            RowBox[{
            "take", " ", "absolute", " ", "values", " ", "to", " ", "prevent",
              " ", "negative", " ", "fit", " ", "results"}], " ", "*)"}], 
           "\[IndentingNewLine]", 
           RowBox[{"(*", 
            RowBox[{
             RowBox[{"AccuracyGoal", " ", "->", " ", "5"}], ",", " ", 
             RowBox[{"PrecisionGoal", " ", "->", " ", "5"}]}], "*)"}], "]"}], 
          "  ", 
          RowBox[{"(*", " ", 
           RowBox[{
           "Try", " ", "to", " ", "reduce", " ", "computation", " ", "time", 
            " ", "by", " ", "asking", " ", "for", " ", "lower", " ", 
            "accuracy", " ", "and", " ", 
            RowBox[{"precision", "."}]}], "*)"}], "\[IndentingNewLine]", ",", 
          "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"\[Mu]l", ",", "\[Mu]linitial"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"\[Sigma]l", ",", "\[Sigma]linitial"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"\[Mu]r", ",", "\[Mu]rinitial"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"\[Sigma]r", ",", "\[Sigma]rinitial"}], "}"}]}], "}"}], 
          ",", "\[IndentingNewLine]", 
          RowBox[{"StepMonitor", "\[RuleDelayed]", 
           RowBox[{"Print", "[", 
            RowBox[{
            "\"\<\[Mu]l = \>\"", ",", "\[Mu]l", ",", "\"\< \[Sigma]l = \>\"", 
             ",", "\[Sigma]l", ",", "\"\< \[Mu]r = \>\"", ",", 
             RowBox[{"\[Mu]r", "\"\< \[Sigma]r = \>\""}], ",", "\[Sigma]r"}], 
            "]"}]}], ",", "\[IndentingNewLine]", 
          RowBox[{"Method", "->", "\"\<QuasiNewton\>\""}]}], 
         "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"Return", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"#", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "->", 
             RowBox[{"Abs", "[", 
              RowBox[{"#", "[", 
               RowBox[{"[", "2", "]"}], "]"}], "]"}]}], "&"}], "/@", 
           RowBox[{"fmfSLR", "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], ")"}], "~", "Join", "~", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"\[Mu]lx", "->", 
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{"\[Mu]l", "+", 
                FractionBox[
                 SuperscriptBox["\[Sigma]l", "2"], "2"]}]]}], ",", 
             RowBox[{"\[Sigma]lx", "->", 
              RowBox[{
               SuperscriptBox["\[ExponentialE]", "\[Mu]l"], " ", 
               RowBox[{"\[Sqrt]", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox["\[ExponentialE]", 
                   SuperscriptBox["\[Sigma]l", "2"]], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["\[ExponentialE]", 
                    SuperscriptBox["\[Sigma]l", "2"]], "-", "1"}], ")"}]}], 
                 ")"}]}]}]}], ",", 
             RowBox[{"\[Mu]rx", "->", 
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{"\[Mu]r", "+", 
                FractionBox[
                 SuperscriptBox["\[Sigma]r", "2"], "2"]}]]}], ",", 
             RowBox[{"\[Sigma]rx", "->", 
              RowBox[{
               SuperscriptBox["\[ExponentialE]", "\[Mu]r"], " ", 
               RowBox[{"\[Sqrt]", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox["\[ExponentialE]", 
                   SuperscriptBox["\[Sigma]r", "2"]], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["\[ExponentialE]", 
                    SuperscriptBox["\[Sigma]r", "2"]], "-", "1"}], ")"}]}], 
                 ")"}]}]}]}]}], "}"}], "/.", 
           RowBox[{"fmfSLR", "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], ")"}]}], 
        RowBox[{"(*", " ", 
         RowBox[{
         "take", " ", "absolute", " ", "values", " ", "to", " ", "prevent", 
          " ", "negative", " ", "fit", " ", "results"}], " ", "*)"}], 
        "\[IndentingNewLine]", "]"}]}]}], "\[IndentingNewLine]", 
     "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{
  3.853833992055169*^9, {3.853838966450965*^9, 3.853838966553301*^9}, {
   3.8544234235752993`*^9, 3.854423436127577*^9}, {3.854430087163003*^9, 
   3.854430130510928*^9}, {3.854430203830633*^9, 3.854430219131062*^9}, {
   3.8601385420212803`*^9, 3.860138638056221*^9}, {3.8601386828025064`*^9, 
   3.860138692836401*^9}, {3.8619498070714016`*^9, 3.861949810669832*^9}, {
   3.864111368481957*^9, 3.864111381547614*^9}, {3.8641119129600077`*^9, 
   3.864111933466826*^9}, {3.86411198099782*^9, 3.8641120377855062`*^9}, {
   3.864112243724079*^9, 3.8641122604900866`*^9}, {3.864112766219705*^9, 
   3.86411278769474*^9}, {3.8641135528767495`*^9, 3.8641135674698086`*^9}, {
   3.8641136364748583`*^9, 3.8641136872689133`*^9}, {3.864115609508887*^9, 
   3.864115696314577*^9}, {3.864115732636894*^9, 3.864115830964185*^9}, {
   3.8641158807267537`*^9, 3.8641158812495947`*^9}, {3.8641159142672977`*^9, 
   3.864115966691824*^9}, {3.8641160299919057`*^9, 3.8641160563528504`*^9}, {
   3.8641161004319696`*^9, 3.8641161468625154`*^9}, {3.8641161798404274`*^9, 
   3.8641161881638513`*^9}, {3.864116300781921*^9, 3.864116303316224*^9}, {
   3.864117598850899*^9, 3.864117610456077*^9}, {3.864117641542405*^9, 
   3.8641176697889366`*^9}, {3.864180413527955*^9, 3.864180439734521*^9}, {
   3.8641804809675617`*^9, 3.8641805484890027`*^9}, {3.864439294957782*^9, 
   3.8644393039048176`*^9}, {3.8644393915786576`*^9, 3.864439422827739*^9}, {
   3.864439453939878*^9, 3.864439469354518*^9}, {3.864439507094865*^9, 
   3.864439508154552*^9}, 3.8644397191828737`*^9, {3.8644398454503803`*^9, 
   3.8644398477143235`*^9}, {3.8644399339387035`*^9, 3.86443994606491*^9}, {
   3.886064903615081*^9, 3.8860649365245705`*^9}, {3.8860649824235754`*^9, 
   3.886065042163972*^9}, {3.8860654296691275`*^9, 3.8860654298245497`*^9}, {
   3.8860658521704564`*^9, 3.886065874983266*^9}, {3.886066040165041*^9, 
   3.886066041373247*^9}, {3.8860666771353765`*^9, 3.8860666867852397`*^9}, {
   3.887182510322879*^9, 3.887182533881962*^9}, 3.887182594924156*^9, {
   3.888309810352276*^9, 3.8883099090736856`*^9}, 3.888309979546259*^9, {
   3.889001517107656*^9, 3.889001521496806*^9}, 3.8890015518214397`*^9, {
   3.8890016534686737`*^9, 3.8890016557649727`*^9}, {3.8890018189941072`*^9, 
   3.8890019390049477`*^9}, {3.889001975497669*^9, 3.8890020072173767`*^9}, {
   3.889002614228364*^9, 3.8890026313484697`*^9}, {3.889077832884159*^9, 
   3.889077894603732*^9}, {3.889080182454623*^9, 3.889080182537393*^9}, {
   3.8890822541823463`*^9, 3.8890822952851562`*^9}, {3.889082341655233*^9, 
   3.889082344557757*^9}, {3.889082656479224*^9, 3.8890826670260477`*^9}, {
   3.8890828570654707`*^9, 3.889082869681726*^9}, {3.889082911422908*^9, 
   3.889082918957836*^9}, {3.8895003750115547`*^9, 3.8895003897150297`*^9}, {
   3.8895018994156485`*^9, 3.8895019010220375`*^9}, {3.889503150539938*^9, 
   3.8895031777290506`*^9}, {3.8896809063671813`*^9, 
   3.8896810153449264`*^9}, {3.8896810571842823`*^9, 
   3.8896811412259593`*^9}, {3.889681489021313*^9, 3.8896815167211204`*^9}, {
   3.8896816106523666`*^9, 3.8896817796390357`*^9}, {3.8896820398977776`*^9, 
   3.889682095914321*^9}, 3.8896821349393435`*^9, {3.889682203278436*^9, 
   3.8896822073970346`*^9}, 3.889682405803105*^9, {3.889683225636203*^9, 
   3.8896832268268085`*^9}, {3.889683264087661*^9, 3.8896832726744494`*^9}, {
   3.8902008849918118`*^9, 3.890200911254434*^9}, {3.891414478168077*^9, 
   3.89141454535581*^9}, {3.8914145789251857`*^9, 3.891414624133849*^9}, {
   3.8914150625685744`*^9, 3.8914152262658043`*^9}, {3.8914159481837835`*^9, 
   3.8914159627995386`*^9}, {3.891417522295415*^9, 3.8914175385413494`*^9}, 
   3.891427879634804*^9, {3.891427987429741*^9, 3.8914280388778486`*^9}, {
   3.8914908223125954`*^9, 3.8914908272757816`*^9}, {3.905228372076123*^9, 
   3.905228384803872*^9}},
 CellLabel->"In[43]:=",ExpressionUUID->"4d2ca9cf-a791-490d-b630-3cfaa5886fc0"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Plot settings", "Section",
 CellChangeTimes->{{3.9042103487363567`*^9, 
  3.904210353447942*^9}},ExpressionUUID->"ea7d68f2-5356-49b3-95f0-\
1a6e38787f2a"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"inch", " ", "=", " ", "84"}], " ", ";"}], 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Should", " ", "be", " ", "72", " ", "for", " ", "Mac", " ", "or", " ", 
     "96", " ", "for", " ", "windows"}], ",", " ", 
    RowBox[{
    "but", " ", "somehow", " ", "I", " ", "dont", " ", "obtain", " ", "the", 
     " ", "specified", " ", "image", " ", "sizes", " ", "that", " ", 
     RowBox[{"way", "."}]}]}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"cm", " ", "=", " ", 
   RowBox[{"inch", "/", "2.54"}]}], ";"}]}], "Input",
 CellLabel->"In[44]:=",ExpressionUUID->"1e2ec847-da37-43d8-8641-1323717c97b4"],

Cell[CellGroupData[{

Cell["\<\
Function to get logarithmic tick marks in scientific notation\
\>", "Subsection",
 CellChangeTimes->{{3.889675803215909*^9, 
  3.889675825628518*^9}},ExpressionUUID->"2c7e915b-284b-4a52-9077-\
42b65bc60a51"],

Cell["\<\
From https://stackoverflow.com/questions/5669073/force-scientific-notation-in-\
tick-labels-of-listloglogplot. \[LineSeparator]Was really annoyed that \
apparently it\[CloseCurlyQuote]s super hard to choose your own tick labels in \
mathematica in combination with logarithmic tick marks\
\>", "Text",
 CellChangeTimes->{{3.8896758423204074`*^9, 3.889675874699585*^9}, {
  3.8896759137086077`*^9, 
  3.8896759250674143`*^9}},ExpressionUUID->"0716ec73-f7da-4d51-adfc-\
df2d5f6b72d6"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"PowerTicks", "[", "label_", "]"}], "[", 
    RowBox[{"min_", ",", "max_"}], "]"}], ":=", 
   RowBox[{"Block", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"min10", ",", "max10"}], "}"}], ",", 
     RowBox[{
      RowBox[{"min10", "=", 
       RowBox[{"Floor", "[", 
        RowBox[{"Log10", "[", "min", "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"max10", "=", 
       RowBox[{"Ceiling", "[", 
        RowBox[{"Log10", "[", "max", "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Join", "[", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"10", "^", "i"}], ",", 
            RowBox[{"If", "[", 
             RowBox[{"label", ",", 
              RowBox[{"Superscript", "[", 
               RowBox[{"10", ",", "i"}], "]"}], ",", 
              RowBox[{"Spacer", "[", 
               RowBox[{"{", 
                RowBox[{"0", ",", "0"}], "}"}], "]"}]}], "]"}]}], "}"}], ",", 
          
          RowBox[{"{", 
           RowBox[{"i", ",", "min10", ",", "max10"}], "}"}]}], "]"}], ",", 
        RowBox[{"Flatten", "[", 
         RowBox[{
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"k", " ", 
               RowBox[{"10", "^", "i"}]}], ",", 
              RowBox[{"Spacer", "[", 
               RowBox[{"{", 
                RowBox[{"0", ",", "0"}], "}"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"0.005", ",", "0.`"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"Thickness", "[", "0.001`", "]"}], "}"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"i", ",", "min10", ",", "max10"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"k", ",", "9"}], "}"}]}], "]"}], ",", "1"}], "]"}]}], 
       "]"}]}]}], "]"}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"use", " ", "example"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"ListLogLogPlot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Range", "[", "20", "]"}], "^", "3"}], ",", 
     RowBox[{"Frame", "->", "True"}], ",", 
     RowBox[{"FrameTicks", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
          RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
          RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}]}], 
    "]"}], "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "skip", " ", "every", " ", "second", " ", "tick", " ", "label", " ", "for",
     " ", "readability"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PowerTicks2", "[", "label_", "]"}], "[", 
   RowBox[{"min_", ",", "max_"}], "]"}], ":=", 
  RowBox[{"Block", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"min10", ",", "max10"}], "}"}], ",", 
    RowBox[{
     RowBox[{"min10", "=", 
      RowBox[{"Floor", "[", 
       RowBox[{"Log10", "[", "min", "]"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"max10", "=", 
      RowBox[{"Ceiling", "[", 
       RowBox[{"Log10", "[", "max", "]"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", 
      RowBox[{
       RowBox[{"Join", "[", 
        RowBox[{
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"10", "^", "i"}], ",", 
             RowBox[{"If", "[", 
              RowBox[{"label", ",", 
               RowBox[{"Superscript", "[", 
                RowBox[{"10", ",", "i"}], "]"}], ",", 
               RowBox[{"Spacer", "[", 
                RowBox[{"{", 
                 RowBox[{"0", ",", "0"}], "}"}], "]"}]}], "]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"i", ",", "min10", ",", "max10", ",", "2"}], "}"}]}], 
          "]"}], ",", 
         RowBox[{"Flatten", "[", 
          RowBox[{
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"k", " ", 
                RowBox[{"10", "^", "i"}]}], ",", 
               RowBox[{"Spacer", "[", 
                RowBox[{"{", 
                 RowBox[{"0", ",", "0"}], "}"}], "]"}], ",", 
               RowBox[{"{", 
                RowBox[{"0.005", ",", "0.`"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"Thickness", "[", "0.001`", "]"}], "}"}]}], "}"}], 
             ",", 
             RowBox[{"{", 
              RowBox[{"i", ",", "min10", ",", "max10"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"k", ",", "9"}], "}"}]}], "]"}], ",", "1"}], "]"}]}], 
        "]"}], "]"}], "*)"}], "\[IndentingNewLine]", 
     RowBox[{"Join", "[", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"10", "^", "i"}], ",", 
           RowBox[{"If", "[", 
            RowBox[{"label", ",", 
             RowBox[{"Superscript", "[", 
              RowBox[{"10", ",", "i"}], "]"}], ",", 
             RowBox[{"Spacer", "[", 
              RowBox[{"{", 
               RowBox[{"0", ",", "0"}], "}"}], "]"}]}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "min10", ",", "max10", ",", "2"}], "}"}]}], "]"}],
        ",", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"10", "^", "i"}], ",", 
           RowBox[{"If", "[", 
            RowBox[{"label", ",", " ", 
             RowBox[{"Spacer", "[", 
              RowBox[{"{", 
               RowBox[{"0", ",", "0"}], "}"}], "]"}]}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", 
           RowBox[{"10", "min10"}], ",", 
           RowBox[{"10", "max10"}], ",", "2"}], "}"}]}], "]"}], ",", 
       RowBox[{"Flatten", "[", 
        RowBox[{
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"k", " ", 
              RowBox[{"10", "^", "i"}]}], ",", 
             RowBox[{"Spacer", "[", 
              RowBox[{"{", 
               RowBox[{"0", ",", "0"}], "}"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"0.005", ",", "0.`"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"Thickness", "[", "0.001`", "]"}], "}"}]}], "}"}], ",", 
           
           RowBox[{"{", 
            RowBox[{"i", ",", "min10", ",", "max10"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"k", ",", "9"}], "}"}]}], "]"}], ",", "1"}], "]"}]}], 
      "]"}]}]}], "]"}]}]}], "Input",
 CellChangeTimes->{
  3.8896758773232393`*^9, {3.8896759377796016`*^9, 3.889675951308181*^9}, 
   3.9041934750089507`*^9, 3.904210369538686*^9},
 CellLabel->"In[46]:=",ExpressionUUID->"3ff1d24a-bfe7-4aef-b22b-89321bdbef81"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Title",
 CellChangeTimes->{{3.889081816418654*^9, 
  3.8890818172763433`*^9}},ExpressionUUID->"d8104e96-bcdf-4d40-8ea7-\
520991da3e70"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "convert", " ", "mu_x", " ", "and", " ", "sigma_x", " ", "vs", " ", "mu", 
    " ", "and", " ", "sigma"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"EstimateMu", "[", 
     RowBox[{"mux_", ",", "sigmax_"}], "]"}], ":=", " ", 
    RowBox[{"1.", " ", 
     RowBox[{"Log", "[", 
      RowBox[{
       RowBox[{"mux", "^", "2"}], "/", 
       RowBox[{"Sqrt", "[", 
        RowBox[{
         RowBox[{"mux", "^", "2"}], " ", "+", " ", 
         RowBox[{"sigmax", "^", "2"}]}], "]"}]}], "]"}]}]}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"EstimateSigma", "[", 
     RowBox[{"mux_", ",", " ", "sigmax_"}], "]"}], ":=", 
    RowBox[{"1.", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"Log", "[", 
       RowBox[{"1", " ", "+", " ", 
        RowBox[{
         RowBox[{"sigmax", "^", "2"}], "/", 
         RowBox[{"mux", "^", "2"}]}]}], "]"}], "]"}]}]}], 
   "\[IndentingNewLine]", 
   RowBox[{"EstimateMu", "[", 
    RowBox[{"250", ",", "10"}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"EstimateSigma", "[", 
    RowBox[{"250", ",", "10"}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"EstimateMu", "[", 
    RowBox[{"300", ",", "205"}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"EstimateSigma", "[", 
    RowBox[{"300", ",", "205"}], "]"}]}]}]], "Input",
 CellLabel->"In[48]:=",ExpressionUUID->"f59751bb-bd6c-4cae-9851-1a4226146c36"],

Cell[BoxData["5.520661557180397`"], "Output",
 CellChangeTimes->{3.906015768670044*^9, 3.9137856804624195`*^9, 
  3.917000438960885*^9},
 CellLabel->"Out[50]=",ExpressionUUID->"5ca11099-453a-42d9-ae20-c797b33dea12"],

Cell[BoxData["0.039984013851751724`"], "Output",
 CellChangeTimes->{3.906015768670044*^9, 3.9137856804624195`*^9, 
  3.9170004389676833`*^9},
 CellLabel->"Out[51]=",ExpressionUUID->"f206033c-e608-4b44-8bea-b41bdb678a77"],

Cell[BoxData["5.512191660524835`"], "Output",
 CellChangeTimes->{3.906015768670044*^9, 3.9137856804624195`*^9, 
  3.917000438973699*^9},
 CellLabel->"Out[52]=",ExpressionUUID->"abf6bb0d-3e17-4810-b56b-69bc753df5c5"],

Cell[BoxData["0.6190166623466058`"], "Output",
 CellChangeTimes->{3.906015768670044*^9, 3.9137856804624195`*^9, 
  3.9170004389780564`*^9},
 CellLabel->"Out[53]=",ExpressionUUID->"969a928a-c448-4b73-bf14-ae9cb08f3541"],

Cell[BoxData["5.520661557180397`"], "Output",
 CellChangeTimes->{3.91741631767371*^9},
 CellLabel->"Out[50]=",ExpressionUUID->"154e519c-a7e2-48d4-b64f-2fca60e3de00"],

Cell[BoxData["0.039984013851751724`"], "Output",
 CellChangeTimes->{3.9174163176819954`*^9},
 CellLabel->"Out[51]=",ExpressionUUID->"9623277c-3e75-4aba-9cda-1702a0ceefad"],

Cell[BoxData["5.512191660524835`"], "Output",
 CellChangeTimes->{3.9174163176910405`*^9},
 CellLabel->"Out[52]=",ExpressionUUID->"e6722b0e-86ed-438e-81fb-b9c774494830"],

Cell[BoxData["0.6190166623466058`"], "Output",
 CellChangeTimes->{3.9174163176970406`*^9},
 CellLabel->"Out[53]=",ExpressionUUID->"f0e7b18b-eb6f-422f-8389-795d9c7a18c1"],

Cell[BoxData["5.520661557180397`"], "Output",
 CellChangeTimes->{3.9174219127778535`*^9},
 CellLabel->"Out[50]=",ExpressionUUID->"3fe8bf54-5b96-4864-b44d-a18d663ea790"],

Cell[BoxData["0.039984013851751724`"], "Output",
 CellChangeTimes->{3.917421912783889*^9},
 CellLabel->"Out[51]=",ExpressionUUID->"30dfb13e-2a77-491c-b7f6-0e2e4c2cce36"],

Cell[BoxData["5.512191660524835`"], "Output",
 CellChangeTimes->{3.917421912801243*^9},
 CellLabel->"Out[52]=",ExpressionUUID->"b7e6ffed-e7c9-4b40-bbc2-5b3d50e2cd86"],

Cell[BoxData["0.6190166623466058`"], "Output",
 CellChangeTimes->{3.917421912826663*^9},
 CellLabel->"Out[53]=",ExpressionUUID->"061c4132-7f90-4246-bbde-ef300d95a87f"],

Cell[BoxData["5.520661557180397`"], "Output",
 CellChangeTimes->{3.9174235027436576`*^9},
 CellLabel->"Out[50]=",ExpressionUUID->"ab303a5f-7393-4981-9594-9bd59fefe014"],

Cell[BoxData["0.039984013851751724`"], "Output",
 CellChangeTimes->{3.9174235027523284`*^9},
 CellLabel->"Out[51]=",ExpressionUUID->"e2b5568d-47d6-4e92-81de-b872683d0904"],

Cell[BoxData["5.512191660524835`"], "Output",
 CellChangeTimes->{3.9174235027573314`*^9},
 CellLabel->"Out[52]=",ExpressionUUID->"34252ed7-8c5d-4350-86ad-7f95ac7f8eff"],

Cell[BoxData["0.6190166623466058`"], "Output",
 CellChangeTimes->{3.9174235027642217`*^9},
 CellLabel->"Out[53]=",ExpressionUUID->"7bf786a0-9236-4d87-909c-005259641830"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1428., 819.75},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Magnification:>0.7 Inherited,
FrontEndVersion->"13.2 for Microsoft Windows (64-bit) (January 30, 2023)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"7b4b0030-b6c3-40d0-9cc1-2df637420d8e"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 291, 4, 68, "Title",ExpressionUUID->"9752d005-1219-465f-8e60-2082113917f8"],
Cell[874, 28, 568, 12, 40, "Text",ExpressionUUID->"49403409-d150-494f-b081-91ce56c28d83"],
Cell[1445, 42, 275, 6, 22, "Item",ExpressionUUID->"c5bb304f-f48f-4254-b437-103257a6e918"],
Cell[1723, 50, 453, 9, 22, "Item",ExpressionUUID->"ae041ac8-eae0-47a3-9bd9-39e8721130f8"],
Cell[CellGroupData[{
Cell[2201, 63, 180, 3, 32, "Subsubsection",ExpressionUUID->"e214e2f0-1723-47e3-b5e6-cc97977345b1"],
Cell[2384, 68, 420, 11, 34, "Input",ExpressionUUID->"6a1e2f36-ed4d-4204-a5ee-f5fb0ba7e773"],
Cell[CellGroupData[{
Cell[2829, 83, 4941, 93, 140, "Input",ExpressionUUID->"bb5b9391-51b5-4754-9301-f8ac33c801e3"],
Cell[7773, 178, 979, 14, 23, "Output",ExpressionUUID->"233d6aa5-d457-412b-8648-9fb24a1d7329"],
Cell[8755, 194, 814, 12, 23, "Output",ExpressionUUID->"cfdb79b9-eb3d-432a-8f19-2b7a9b73b56f"]
}, Open  ]],
Cell[9584, 209, 2233, 52, 180, "Input",ExpressionUUID->"fc5fd8e9-fab4-4b5c-b2af-d0e7dff8366f"],
Cell[11820, 263, 6773, 174, 247, "Input",ExpressionUUID->"963c927a-6081-41b1-bcc3-11370c5e23da"]
}, Open  ]],
Cell[CellGroupData[{
Cell[18630, 442, 269, 5, 32, "Subsubsection",ExpressionUUID->"bb1efd3e-4cfd-424b-89f2-969547bc7a05"],
Cell[CellGroupData[{
Cell[18924, 451, 31231, 721, 2043, "Input",ExpressionUUID->"f2858960-ee9b-434f-ab6f-b0967ca77d38"],
Cell[50158, 1174, 7679, 120, 116, "Output",ExpressionUUID->"f9b6c3c3-9552-4f46-b682-1e83f803b85c"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[57886, 1300, 217, 4, 37, "Subsection",ExpressionUUID->"9ecbbbc5-8b8f-4847-b220-8094510e4a4e"],
Cell[58106, 1306, 335, 7, 24, "Text",ExpressionUUID->"1226fcdb-2e55-460d-933b-f363aeb6389f"],
Cell[CellGroupData[{
Cell[58466, 1317, 17718, 411, 1169, "Input",ExpressionUUID->"904598d3-3be1-4b29-9812-e84f814faf5c"],
Cell[76187, 1730, 368, 5, 23, "Output",ExpressionUUID->"24a2b4f1-f326-4e5e-8283-1293f6ce0c8d"],
Cell[76558, 1737, 1054, 28, 55, "Output",ExpressionUUID->"8c43dfeb-5a37-4948-91ab-304090a8d307"]
}, Open  ]],
Cell[77627, 1768, 12600, 254, 478, "Input",ExpressionUUID->"4d2ca9cf-a791-490d-b630-3cfaa5886fc0"]
}, Open  ]],
Cell[CellGroupData[{
Cell[90264, 2027, 160, 3, 47, "Section",ExpressionUUID->"ea7d68f2-5356-49b3-95f0-1a6e38787f2a"],
Cell[90427, 2032, 667, 16, 34, "Input",ExpressionUUID->"1e2ec847-da37-43d8-8641-1323717c97b4"],
Cell[CellGroupData[{
Cell[91119, 2052, 217, 5, 37, "Subsection",ExpressionUUID->"2c7e915b-284b-4a52-9077-42b65bc60a51"],
Cell[91339, 2059, 492, 9, 40, "Text",ExpressionUUID->"0716ec73-f7da-4d51-adfc-df2d5f6b72d6"],
Cell[91834, 2070, 7074, 192, 167, "Input",ExpressionUUID->"3ff1d24a-bfe7-4aef-b22b-89321bdbef81"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[98969, 2269, 153, 3, 68, "Title",ExpressionUUID->"d8104e96-bcdf-4d40-8ea7-520991da3e70"],
Cell[CellGroupData[{
Cell[99147, 2276, 1419, 38, 100, "Input",ExpressionUUID->"f59751bb-bd6c-4cae-9851-1a4226146c36"],
Cell[100569, 2316, 215, 3, 23, "Output",ExpressionUUID->"5ca11099-453a-42d9-ae20-c797b33dea12"],
Cell[100787, 2321, 220, 3, 23, "Output",ExpressionUUID->"f206033c-e608-4b44-8bea-b41bdb678a77"],
Cell[101010, 2326, 215, 3, 23, "Output",ExpressionUUID->"abf6bb0d-3e17-4810-b56b-69bc753df5c5"],
Cell[101228, 2331, 218, 3, 23, "Output",ExpressionUUID->"969a928a-c448-4b73-bf14-ae9cb08f3541"],
Cell[101449, 2336, 165, 2, 23, "Output",ExpressionUUID->"154e519c-a7e2-48d4-b64f-2fca60e3de00"],
Cell[101617, 2340, 171, 2, 23, "Output",ExpressionUUID->"9623277c-3e75-4aba-9cda-1702a0ceefad"],
Cell[101791, 2344, 168, 2, 23, "Output",ExpressionUUID->"e6722b0e-86ed-438e-81fb-b9c774494830"],
Cell[101962, 2348, 169, 2, 23, "Output",ExpressionUUID->"f0e7b18b-eb6f-422f-8389-795d9c7a18c1"],
Cell[102134, 2352, 168, 2, 23, "Output",ExpressionUUID->"3fe8bf54-5b96-4864-b44d-a18d663ea790"],
Cell[102305, 2356, 169, 2, 23, "Output",ExpressionUUID->"30dfb13e-2a77-491c-b7f6-0e2e4c2cce36"],
Cell[102477, 2360, 166, 2, 23, "Output",ExpressionUUID->"b7e6ffed-e7c9-4b40-bbc2-5b3d50e2cd86"],
Cell[102646, 2364, 167, 2, 23, "Output",ExpressionUUID->"061c4132-7f90-4246-bbde-ef300d95a87f"],
Cell[102816, 2368, 168, 2, 23, "Output",ExpressionUUID->"ab303a5f-7393-4981-9594-9bd59fefe014"],
Cell[102987, 2372, 171, 2, 23, "Output",ExpressionUUID->"e2b5568d-47d6-4e92-81de-b872683d0904"],
Cell[103161, 2376, 168, 2, 23, "Output",ExpressionUUID->"34252ed7-8c5d-4350-86ad-7f95ac7f8eff"],
Cell[103332, 2380, 169, 2, 23, "Output",ExpressionUUID->"7bf786a0-9236-4d87-909c-005259641830"]
}, Open  ]]
}, Open  ]]
}
]
*)

